/*
   Project: Cartotheque

   Copyright (C) 2005 Stefan Urbanek

   Author : Stefan Urbanek
   Created: 2005-01-27
   License: GNU LGPL 2.1
*/

#import <Foundation/NSObject.h>

@class NSAttributedString;
@class CardRepository;

/** Card class | retained exposed objects nosuperarchive */
@interface Card : NSObject
{
    CardRepository     *repository; /** | readonly notarchived */
    id                  identifier; /** | readonly */
    NSDictionary       *info;       /** | hidden */
    id                  contents;   /** | hidden */
    BOOL                isDirty;    /** | */
}
- initWithRepository:(CardRepository *)rep identifier:(id)ident;
- (id)contents;
- (void)setContents:(id)_value;
- (NSDictionary *)info;
- (void)setInfo:(NSDictionary *)_value;
- (void)invalidate;
- (BOOL)isValid;
@end

/* BEGIN Generated by DevelKit */
@interface Card (DKGeneratedMethods)
- (id)identifier;
- (CardRepository *)repository;
- (BOOL)isDirty;
- (void)setIsDirty:(BOOL)_value;
@end
/* END Generated by DevelKit */
