/*
   Project: Cartotheque

   Copyright (C) 2005 Stefan Urbanek

   Author : Stefan Urbanek
   Created: 2005-01-27
   License: GNU LGPL 2.1
*/

#import "CardController.m"

#import <Foundation/NSException.h>
#import <AppKit/NSTextView.h>
#import <AppKit/NSTextStorage.h>

@implementation CardWindowController
- initWithCard:(Stack *)aStack
{
    self = [super initWithWindowNibName:@"CardWindow"];
    stack = RETAIN(aStack);
    return self;
}

- (void)dealloc
{
    RELEASE(stack);
    RELEASE(currentCard);
}
- (void)titleChanged:(id)sender
{
    [currentCard setTitle:[titleField currentValue]];
}
- (void)createCard:(id)sender
{
    Card *newCard;
    newCard = RETAIN([stack createCard]);
    [self setCurrentCard:newCard];
}
- (void)removeCard:(id)sender
{
    if([currentCard isEqual:[wiki homeCard]])
    {
        [NSException raise:@"CardException"
                     format:@"Should not remove home card"];
        return;
    }
    else
    {
        [wiki removeCard:currentCard];
        [self goToHomeCard];
    }
}

- (void)goToPreviousCard:(id)sender
{
    [self setCurrentCard:[wiki previousCardRelativeToCard:currentCard]];
}
- (void)goToNextCard:(id)sender
{
    [self setCurrentCard:[wiki nextCardRelativeToCard:currentCard]];
}
- (void)goToHomeCard:(id)sender
{
    [self setCurrentCard:[wiki homeCard]];
}
- (void)setCurrentCard:(Card *)card
{
    NSAttributedString *string;
    
    [self updateCardContents];

    string = [card contents];
    [[view textStorage] setAttributedString:string];
    [titleField setStringValue:[card title]];
}
- (void)textDidChange:(NSNotification *)notif
{
    /* FIXME: this is slow. try to delay this method to 1s after last editing */
    [self updateCardContents];
}
- (void)updateCardContents
{
    [currentCard setContents:[[view textStorage] attributedString]];
}
@end
/* BEGIN Generated by DevelKit */

@implementation CardController (DKGeneratedMethods)
/* Accessor methods */

- (void)dealloc
{

    [super dealloc];
}

/* Encoding methods */
- (void)encodeWithCoder:(NSCoder *)coder
{
    // NSLog(@"Encoding class %@", [self className]);
    [super encodeWithCoder:coder];
    if ( [coder allowsKeyedCoding] )
    {
        [coder encodeObject:currentCard forKey:@"currentCard"];
        [coder encodeObject:titleField forKey:@"titleField"];
        [coder encodeObject:view forKey:@"view"];
        [coder encodeObject:stack forKey:@"stack"];
    }
    else
    {
        [coder encodeValueOfObjCType: @encode(Card *) at: &currentCard];
        [coder encodeValueOfObjCType: @encode(NSTextField *) at: &titleField];
        [coder encodeValueOfObjCType: @encode(CardView *) at: &view];
        [coder encodeValueOfObjCType: @encode(Stack *) at: &stack];
    }
}
- initWithCoder:(NSCoder *)decoder
{
    self = [super initWithCoder:decoder];
    if ( [decoder allowsKeyedCoding] )
    {
        currentCard = [decoder decodeObjectForKey:@"currentCard"];
        titleField = [decoder decodeObjectForKey:@"titleField"];
        view = [decoder decodeObjectForKey:@"view"];
        stack = [decoder decodeObjectForKey:@"stack"];
    }
    else
    {
        [decoder decodeValueOfObjCType: @encode(Card *) at: &currentCard];
        [decoder decodeValueOfObjCType: @encode(NSTextField *) at: &titleField];
        [decoder decodeValueOfObjCType: @encode(CardView *) at: &view];
        [decoder decodeValueOfObjCType: @encode(Stack *) at: &stack];
    }


    return self;
}

@end
/* END Generated by DevelKit */
