/*
   Project: Cartotheque

   Copyright (C) 2005 Stefan Urbanek

   Author : Stefan Urbanek
   Created: 2005-01-27
   License: GNU LGPL 2.1
*/

#import "CardInspector.h"

#import "Card.h"

#import <Foundation/NSCoder.h>
#import <Foundation/NSString.h>

#import <AppKit/NSTextField.h>

@implementation CardInspector
- (NSString *)nibName
{
	return @"CardInspector";
}
- (NSString *)title
{
	return @"Card";
}
- (void)targetChanged
{
	[nameField setStringValue:[(Card *)target identifier]];
	[dateField setObjectValue:
                    [[target info] objectForKey:@"creationDate"]];
}
- (void)nameChanged:(id)sender
{
    NSLog(@"Name change is not yet implemented!");
    [self targetChanged];
}
@end
