/*
   Project: Cartotheque

   Copyright (C) 2005 Stefan Urbanek

   Author : Stefan Urbanek
   Created: 2005-01-27
   License: GNU LGPL 2.1
*/

#import <Foundation/Foundation.h>

@class NSMutableDictionary;
@class NSDictionary;
@class NSFileManager;


/** Class providing a repository for the cards. The repository is implemented
    as a directory with one file per card. In the future this should change 
    
    | objects nosuperarchive */

@interface CardRepository : NSObject
{
    NSFileManager *fileManager; /** | noarchive */
    NSString      *path;        /** | readonly */
    unsigned int   nextCardID;
    unsigned int   homeCardID;
    NSMutableSet  *allCards;
}
+ (BOOL)createCardRepositoryAtPath:(NSString *)aPath;
- initWithPath:(NSString *)aPath;

- (id)homeCard;
- (void)setHomeCard:(id)card;
- (id)createCard;
- (void)deleteCard:(id)card;
- (NSData *)contentsForCard:(id)card;
- (void)setContents:(NSData *)data forCard:(id)card;

- (NSArray *)allCards;

- (NSDictionary *)infoForCard:(id)card;
- (void)setInfo:(NSDictionary *)info forCard:(id)card;

- (void)commitChanges;
@end

/* BEGIN Generated by DevelKit */
@interface CardRepository (DKGeneratedMethods)
@end
/* END Generated by DevelKit */
