/*
   Project: Cartotheque

   Copyright (C) 2005 Stefan Urbanek

   Author : Stefan Urbanek
   Created: 2005-01-27
   License: GNU LGPL 2.1
*/

#include <AppKit/AppKit.h>
#include "CardWindowController.h"

#import "Card.h"
#import "CardView.h"
#import "CartothequeDocument.h"
#import "Cartotheque.h"

@implementation CardWindowController
- (void)dealloc
{
    RELEASE(card);
    [super dealloc];
}
- (void)setCard:(Card *)aCard
{
    ASSIGN(card,aCard);
    [cardView setCard:aCard];
}
- (Card *)card
{
    return card;
}
- (void)windowDidLoad
{
    [cardView setCard:card];
}
- (void) goToPreviousCard: (id)sender
{
    NSLog(@"Go to previous card");
}
- (void) openCards: (id)sender
{
    [(CartothequeDocument *)[self document] showMainWindow];
}
- (void) goToNextCard: (id)sender
{
    NSLog(@"Go to next card");
}
- (void)commitEditing
{
    NSLog(@"    commit editing of a card?");
    if([cardView isDirty])
    {
        NSLog(@"        YES, commit.");
        [cardView commitEditing];
        [[[self document] cartotheque] touchCard:card];
    }
}
@end
