/*
   Project: Cartotheque

   Copyright (C) 2005 Stefan Urbanek

   Author : Stefan Urbanek
   Created: 2005-01-27
   License: GNU LGPL 2.1
*/

#import <Foundation/NSObject.h>

extern NSString *CardCreatedNotification;
extern NSString *CardEditedNotification;

@class CardRepository;
@class Card;
@class NSMutableSet;
@class NSMutableDictionary;

/** Card container and controller class. 
        | exposed retained objects nosuperarchive */
@interface Cartotheque:NSObject
{
    CardRepository      *repository;    /** | notretained readonly */
    NSMutableDictionary *fetchedCards;  /** | readonly */
    NSMutableSet        *changedCards;  /** | hidden */
}
- initWithRepository:(CardRepository *)aRepository;

- (Card *)homeCard;
- (void)touchCard:(Card *)card;
- (NSArray *)allCards;

- (Card *)createCard;
- (void)deleteCards:(NSArray *)cards;
- (void)deleteCard:(Card *)card;

- (void)commitChanges;
@end

/* BEGIN Generated by DevelKit */
@interface Cartotheque (DKGeneratedMethods)

- (CardRepository *)repository;

@end
/* END Generated by DevelKit */
