/*
   Project: Cartotheque

   Copyright (C) 2005 Stefan Urbanek

   Author : Stefan Urbanek
   Created: 2005-01-27
   License: GNU LGPL 2.1
*/

#import "CartothequeDocument.h"

#import <Foundation/NSNotification.h>
#import <Foundation/NSString.h>
#import <AppKit/NSSavePanel.h>

#import "Cartotheque.h"
#import "CardRepository.h"
#import "CardWindowController.h"
#import "CartothequeWindowController.h"

@interface NSWindowController(CommitEditing)
-(void)commitEditing;
@end

@interface CartothequeDocument(Private)
- (void)_configure;
@end

@implementation CartothequeDocument
- (BOOL)readFromFile:(NSString *)path ofType:(NSString *)type
{
    CardRepository *repository;

    NSLog(@"Reading cartotheque from file '%@'", path);
        
    repository = [[CardRepository alloc] initWithPath:path];
    if(repository)
    {
        cartotheque = [[Cartotheque alloc] initWithRepository:repository];
        AUTORELEASE(repository);
        [self _configure];
    }
    
    return (cartotheque != nil);
}
- (BOOL)writeWithBackupToFile:(NSString *)fullDocumentPath 
                       ofType:(NSString *)docType 
                saveOperation:(NSSaveOperationType)saveOperationType
{
    if(saveOperationType != NSSaveOperation)
    {
        [NSException raise:@"CartothequeException"
                     format:@"Save to/as is not allowed."];
    }
    return [self writeToFile:fullDocumentPath
                      ofType:docType];
}
- (void)_configure
{
    NSNotificationCenter *nc = [NSNotificationCenter defaultCenter];

    [nc removeObserver:self];

    [nc addObserver:self 
           selector:@selector(cartothequeCardsChanged:)
               name:CardCreatedNotification
             object:cartotheque];
}
- (void)close
{
    [[NSNotificationCenter defaultCenter] removeObserver:self];
    [super close];
}
- (BOOL)writeToFile:(NSString *)fileName ofType:(NSString *)docType
{
    /* FIXME: check whether the fileName is the same as repository one */
    /* FIXME: handle exceptions and return NO */
    NSLog(@"Writing to file...");
    [self commitEdits];    
    NSLog(@"    Commit cartotheque changes");
    [cartotheque commitChanges];
    
    return YES;
}
- (void)commitEdits
{
    NSWindowController *controller;
    NSEnumerator       *enumerator;
    
    enumerator = [[self windowControllers] objectEnumerator];
    
    while( (controller = [enumerator nextObject]) )
    {
        if([controller respondsToSelector:@selector(commitEditing)])
        {
            [controller commitEditing];
        }
    }
}
- (BOOL)keepBackupFile
{
    return NO;
}
- (void)dealloc
{
    [[NSNotificationCenter defaultCenter] removeObserver:self];
    RELEASE(cartotheque);
    [super dealloc];
}
- (void)makeWindowControllers
{
    CartothequeWindowController *controller;
   
    controller = [[CartothequeWindowController alloc] 
                            initWithWindowNibName:@"CartothequeWindow"];

    [self addWindowController:controller];
}
- (void)openCard:(Card *)aCard
{
    CardWindowController *controller;
    NSEnumerator         *enumerator;
    
    /* FIXME: find window with same card */
    enumerator = [[self windowControllers] objectEnumerator];
    
    while( (controller = [enumerator nextObject]) )
    {
        if([controller isKindOfClass:[CardWindowController class]])
        {
            NSLog(@"Compare %@ %@", [controller card], aCard);
            if([controller card] == aCard)
            {
                break;
            }
        }
    }
    
    if(!controller)
    {
        controller = [[CardWindowController alloc] 
                            initWithWindowNibName:@"CardWindow"];
        [controller setCard:aCard];
    }
    
    [self addWindowController:controller];

    [[controller window] makeKeyAndOrderFront:self];
}
/********************************************************************
    Card management
********************************************************************/
- (Cartotheque *)cartotheque
{
    return cartotheque;
}
- (void)createCard
{
    Card *card;

    card = [cartotheque createCard];
}
- (void)deleteCards:(NSArray *)cards
{
    [cartotheque deleteCards:cards];
} 
/********************************************************************
    Windows and views
********************************************************************/
- (void)showMainWindow
{
    NSWindowController *controller;
    NSEnumerator       *enumerator;
    
    enumerator = [[self windowControllers] objectEnumerator];
    
    while( (controller = [enumerator nextObject]) )
    {
        if([controller isKindOfClass:[CartothequeWindowController class]])
        {
            [[controller window] makeKeyAndOrderFront:self];
        }
    }
}
- (void)cartothequeCardsChanged:(NSNotification *)notification
{
    NSLog(@"Cartotheque cards changed");
}
@end
