/*
   Project: Cartotheque

   Copyright (C) 2005 Stefan Urbanek

   Author : Stefan Urbanek
   Created: 2005-01-27
   License: GNU LGPL 2.1
*/

#import "AppController.h"

#import <AppKit/NSDocumentController.h>
#import <AppKit/NSSavePanel.h>

#import "EKInspectorPanel.h"
#import "CardInspector.h"

#import "CardRepository.h"

@implementation AppController
- (void)applicationDidFinishLaunching:(NSNotification *)aNotif
{
    NSDocumentController *docController;
    NSURL                *lastURL;
    NSString             *lastPath;
    
    EKInspectorPanel *inspectorPanel;
        
    inspectorPanel = [EKInspectorPanel sharedInspectorPanel];
	[inspectorPanel registerInspector:[CardInspector inspector]
                       withIdentifier:@"CardInspector"];

    [inspectorPanel orderFrontIfVisible];

    docController = [NSDocumentController sharedDocumentController];
    
    /* FIXME: remove this autoloading of last opened cards after testing */
    lastURL = [[docController recentDocumentURLs] lastObject];

    if([lastURL isFileURL])
    {
        lastPath = [lastURL path];
        if(lastPath)
        {
            [docController openDocumentWithContentsOfFile:lastPath display:YES];
        }
    }
}
- (void)newDocument:(id)sender
{
    NSSavePanel *savePanel;
    NSString    *path;
    int          result;
    
    self = [super init];
    
    savePanel = [NSSavePanel savePanel];
    
    [savePanel setRequiredFileType:@"cards"];
    [savePanel setTitle:@"New cartotheque"];

    result = [savePanel runModal];
        
    if(result == NSFileHandlingPanelCancelButton)
    {
        [self dealloc];
        return;
    }

    path = [savePanel filename];

    /* Create card repository and open it. */
    
    if(![CardRepository createCardRepositoryAtPath:path])
    {
        [NSException  raise:@"CartothequeException"
                     format:@"Unable to create card repository at path '%@'",
                        path];
        return;
    }
    else
    {
        NSLog(@"Error: unable to create cartotheque at path: %@", [savePanel filename]);
    }

    [[NSDocumentController sharedDocumentController] 
                    openDocumentWithContentsOfFile:path display:YES];
}
- (void)applicationWillTerminate:(NSNotification *)aNotif
{
    /* FIXME: changes should be commited here */
}
@end
