/*
   Project: Cartotheque

   Copyright (C) 2005 Stefan Urbanek

   Author : Stefan Urbanek
   Created: 2005-01-27
   License: GNU LGPL 2.1
*/

#import "Card.h"

#import "CardRepository.h"

@implementation Card
- initWithRepository:(CardRepository *)rep identifier:(id)ident
{
    self = [super init];
    repository = RETAIN(rep);
    identifier = RETAIN(ident);
    return self;
}

- (id)contents
{
    /* get the contents lazily */
    if(!contents)
    {
        contents = RETAIN([repository contentsForCard:identifier]);
    }
    return contents;
}
- (void)setContents:(NSAttributedString *)_value
{
    ASSIGN(contents,_value);
    isDirty = YES;
}
- (NSDictionary *)info
{
    /* get info lazily */
    if(!info)
    {
        info = RETAIN([repository infoForCard:identifier]);
    }
    return info;
}
- (void)setInfo:(NSDictionary *)_value
{
    ASSIGN(info,_value);
    isDirty = YES;
}
- (NSArray *)inspectorIdentifiers
{
    return [NSArray arrayWithObjects:@"CardInspector", nil];
}
- (BOOL)isValid
{
    return repository != nil;
}
- (void)invalidate
{
    RELEASE(repository);
    repository = nil;
}
@end
/* BEGIN Generated by DevelKit */

@implementation Card (DKGeneratedMethods)
/* Accessor methods */

- (id)identifier
{
    return identifier;
}
- (CardRepository *)repository
{
    return repository;
}
- (BOOL)isDirty
{
    return isDirty;
}
- (void)setIsDirty:(BOOL)_value
{
    isDirty = _value;
}
- (void)dealloc
{
    RELEASE(identifier);
    RELEASE(contents);
    RELEASE(info);
    RELEASE(repository);

    [super dealloc];
}

/* Encoding methods */
- (void)encodeWithCoder:(NSCoder *)coder
{
    // NSLog(@"Encoding class %@", [self className]);
    if ( [coder allowsKeyedCoding] )
    {
        [coder encodeObject:identifier forKey:@"identifier"];
        [coder encodeObject:contents forKey:@"contents"];
        [coder encodeObject:info forKey:@"info"];
        [coder encodeBool:isDirty forKey:@"isDirty"];
    }
    else
    {
        [coder encodeValueOfObjCType: @encode(id) at: &identifier];
        [coder encodeValueOfObjCType: @encode(id) at: &contents];
        [coder encodeValueOfObjCType: @encode(NSDictionary *) at: &info];
        [coder encodeValueOfObjCType: @encode(BOOL) at: &isDirty];
    }
}
- initWithCoder:(NSCoder *)decoder
{
    self = [super init];
    if ( [decoder allowsKeyedCoding] )
    {
        identifier = [decoder decodeObjectForKey:@"identifier"];
        contents = [decoder decodeObjectForKey:@"contents"];
        info = [decoder decodeObjectForKey:@"info"];
        isDirty = [decoder decodeBoolForKey:@"isDirty"];
    }
    else
    {
        [decoder decodeValueOfObjCType: @encode(id) at: &identifier];
        [decoder decodeValueOfObjCType: @encode(id) at: &contents];
        [decoder decodeValueOfObjCType: @encode(NSDictionary *) at: &info];
        [decoder decodeValueOfObjCType: @encode(BOOL) at: &isDirty];
    }

    RETAIN(identifier);
    RETAIN(contents);
    RETAIN(info);

    return self;
}

@end
/* END Generated by DevelKit */
