/*
   Project: Cartotheque

   Copyright (C) 2005 Stefan Urbanek

   Author : Stefan Urbanek
   Created: 2005-Feb
   License: GNU LGPL 2.1
*/

#import <AppKit/NSView.h>

@class Cartotheque;
@class Card;
@class NSMatrix;
@class NSScrollView;

/** | exposed objects */
@interface CardMatrix:NSView
{
    NSScrollView *scrollView;
    NSMatrix     *matrix;
    
    NSSize cardFrameSize;
    NSSize cardSpacing;
    
    Cartotheque *cartotheque;
    
    unsigned int numberOfColumns;
    unsigned int numberOfRows;
    
    id           delegate;
}
- (void)setCartotheque:(Cartotheque *)cards;
- (NSArray *)selectedCards;
- (void)reloadCards;
@end

@interface NSObject(CardMatrixDelegate)
- (void)cardMatrix:(CardMatrix *)matrix didChangeSelection:(NSArray *)cards;
- (void)cardMatrix:(CardMatrix *)matrix openCard:(Card *)card;
@end

