/*
   Project: Cartotheque

   Copyright (C) 2005 Stefan Urbanek

   Author : Stefan Urbanek
   Created: 2005-01-27
   License: GNU LGPL 2.1
*/

#import "CardView.h"

#import <Foundation/NSDictionary.h>
#import <AppKit/NSColor.h>
#import <AppKit/NSFont.h>
#import <AppKit/NSTextStorage.h>

#import "Card.h"

@interface CardView(PrivateMethods)
- (void)_setDefaultAttributes;
@end

@implementation CardView
- initWithFrame:(NSRect)rect
{
    self = [super initWithFrame:rect];
    [[self textStorage] setDelegate:self];
    [self _setDefaultAttributes];
    return self;
}
- (void)awakeFromNib
{    
    [[self textStorage] setDelegate:self];
    [self _setDefaultAttributes];
}
- (void)_setDefaultAttributes
{
    validLinkAttributes = [[NSDictionary alloc] initWithObjectsAndKeys:
                            [NSColor blueColor], NSForegroundColorAttributeName,
                            [NSFont userFontOfSize:0], NSFontAttributeName,
                            nil, nil];
    invalidLinkAttributes = [[NSDictionary alloc] initWithObjectsAndKeys:
                            [NSColor redColor], NSForegroundColorAttributeName,
                            [NSFont userFontOfSize:0], NSFontAttributeName,
                            nil, nil];
}

- (void)setCard:(Card *)card
{
    NSAttributedString *cardText;
    ASSIGN(currentCard, card);
    
    cardText = [currentCard contents];
    [[self textStorage] setAttributedString:cardText];
    isDirty = NO;
}
- (void)commitEditing
{
    NSAttributedString *string;

    if([self isDirty])
    {
        string = [[NSAttributedString alloc] 
                        initWithAttributedString:[self textStorage]];
        [currentCard setContents:AUTORELEASE(string)];
        isDirty = NO;
    }
}

- (Card *)card
{
    return currentCard;
}

- (void)createLinkWithReference:(id)reference
{
    NSRange   range;
    
    if(range.location == NSNotFound || range.length == 0)
    {
        NSLog(@"Warning: attempt to create a link without selection. (ignoring)");
        return;
    }
    
    range = [self selectedRange];

    NSLog(@"Create link to '%@' at %i(%i)", 
                reference, range.location, range.length);

    [[self textStorage] addAttribute:NSLinkAttributeName 
                             value:reference
                             range:range];
}
- (void)textStorageWillProcessEditing:(NSNotification *)notif
{
    isDirty = ([[self textStorage] editedMask] != 0);
}
- (BOOL)isDirty
{
    return isDirty;
}
-(void)clickedOnLink: (id)link atIndex:(int)index
{
    NSLog(@"Clicked on link");
/*
    if([[self delegate] respondsToSelector:@selector(wikiView:clickedOnLink:)])
    {
        [[self delegate] cardView:self clickedOnLink:link];
    }
*/
}

- (void)dealloc
{
    RELEASE(currentCard);
    [super dealloc];
}
@end
