/*
   Project: Cartotheque

   Copyright (C) 2005 Stefan Urbanek

   Author : Stefan Urbanek
   Created: 2005-01-27
   License: GNU LGPL 2.1
*/

#import "CartothequeWindowController.h"
#import "CartothequeDocument.h"

#import <Foundation/NSArray.h>

#import "CardMatrix.h"
#import "CardView.h"

@implementation CartothequeWindowController
- (void) createCard: (id)sender
{
    [(CartothequeDocument *)[self document] createCard];
}

- (void)windowDidLoad
{
    [cardMatrix setCartotheque:[[self document] cartotheque]];
}

- (void) deleteCard: (id)sender
{
    [[self document] deleteCards:[cardMatrix selectedCards]];
}
- (void)cardMatrix:(CardMatrix *)matrix didChangeSelection:(NSArray *)cards
{
    NSLog(@"Card selection changed");
}
- (void)cardMatrix:(CardMatrix *)matrix openCard:(Card *)card
{
    [[self document] openCard:card];
}
@end
