/*
    Project: Environment Kit
    
    Date: 2005-02-26
    Author: Stefan Urbanek
    License: LGPL 1.2
*/

#import "EKFocus.h"

#import "EKInspectorPanel.h"

static EKFocus *applicationFocus = nil;

@implementation EKFocus
+ (EKFocus *)applicationFocus
{
    if(!applicationFocus)
    {
        applicationFocus = [[EKFocus alloc] init];
    }
    return applicationFocus;
}
- (void)dealloc
{
    RELEASE(focusedObject);
    [super dealloc];
}
- (void)setFocusedObject:(id)anObject owner:(id)anOwner
{
    if(anOwner != owner)
    {
        [self setOwner:anOwner];
    }
    [self setFocusedObject:anObject];
}
- (void)setFocusedObject:(id)anObject
{
    [self focusWillChange];
    ASSIGN(focusedObject, anObject);
    [self focusDidChange];
}
- (id)focusedObject
{
    return focusedObject;
}
- (void)focusWillChange
{
    /* Do nothing. This method should be custom defined. */
}
- (void)focusDidChange
{
    [[EKInspectorPanel sharedInspectorPanel]
                            setTarget:focusedObject
                                owner:owner];
}
- (void)setOwner:(id)anObject
{
    /* FIXME: notify about owner change */
    ASSIGN(owner,anObject);
}
- (id)owner
{
    return owner;
}
@end
