/*
    EKInspector - Abstract inspector class

    Project: Environment Kit

    Copyright (C) 2005 Stefan Urbanek

    Author : Stefan Urbanek
    Created: 2005-01-27
    License: GNU LGPL 2.1
*/

#import "EKInspector.h"

#import "EKInspectorPanel.h"

#import <Foundation/NSBundle.h>

#import <AppKit/NSNibLoading.h>
#import <AppKit/NSView.h>
#import <AppKit/NSWindow.h>

@implementation EKInspector
+ inspector
{
    return AUTORELEASE([[self alloc] init]);
}
- infoDictionary
{
    NSDictionary *dict;
    NSBundle     *bundle;
    
    bundle = [NSBundle bundleForClass:[self class]];
    dict = [[bundle infoDictionary] objectForKey:@"Inspectors"];
    dict = [dict objectForKey:[self className]];

    return dict;
}
- (void)dealloc
{
    RELEASE(view);
    [super dealloc];
}
- defaultIdentifier
{
    NSString *str;
    str = [[self infoDictionary] objectForKey:@"Identifier"];
    
    if(!str || [str isEqual:@""])
    {
        str = [self className];
    }
    
    return str;
}
- (NSString *)nibName
{
    return nil;
}
- (BOOL)loadView
{
    if([self nibName] && !view)
    {
        if(![NSBundle loadNibNamed:[self nibName] owner:self])
        {
        	NSLog(@"unable to load view %@", self);
            return NO;
        }
        view = RETAIN([_window contentView]);
        [_window setContentView:nil];
        return YES;
    }
    return NO;
}
- (NSView *)view
{
    if(!view)
    {
        [self loadView];
    }
    return view;
}
- (void)setTarget:(id)newTarget
{
    ASSIGN(target,newTarget);
    [self targetChanged];
}
- (id)target
{
    return target;
}
- (NSString *)title
{
    return @"Unknown Inspector";
}

- (void)setOwner:(id)anObject;
{
    ASSIGN(owner,anObject);
}
- (id)owner;
{
    return owner;
}
- (void)targetChanged
{
    [owner targetChanged];
}
@end
