/*
    EKInspectorPanel

    Project: Environment Kit

    Copyright (C) 2005 Stefan Urbanek

    Author : Stefan Urbanek
    Created: 2005-01-27
    License: GNU LGPL 2.1
*/

#import <AppKit/NSPanel.h>

@class NSBox;
@class NSPopUpButton;
@class NSMutableDictionary;
@class EKInspector;


@interface EKInspectorPanel:NSPanel
{
    id              target;
    NSBox          *inspectorContainerView;
    NSView         *inspectorView;
    NSPopUpButton  *inspectorList;
    NSArray        *activeInspectors; /* identifiers */
    NSMutableDictionary   *inspectorDictionary; /* ident -> inspector */
    id              targetOwner;
}
+ (EKInspectorPanel *)sharedInspectorPanel;

- (void)registerInspector:(EKInspector*)anInspector
           withIdentifier:(NSString *)identifier;
- (void)updateActiveInspectors;

- (void)setTarget:(id)newTarget owner:(id)anObject;
- (void)setTarget:(id)newTarget;

- (void)setTargetOwner:(id)anObject;
- (id)targetOwner;

- (void)orderFrontIfVisible;
- (void)targetChanged;

- (void)selectInspectorWithIdentifier:(NSString *)ident;
- (NSString *)selectedInspectorIdentifier;

- (void)changeInspector:(id)sender;
@end

@interface NSObject(EKInspectorTarget)
- (NSArray *)inspectorIdentifiers;
@end

@interface NSObject(EKInspectorOwner)
- (void)inspectorPanel:(EKInspectorPanel *)panel touchedTarget:(id)target;
@end
