/*
    EKInspectorPanel

    Project: Environment Kit

    Copyright (C) 2005 Stefan Urbanek

    Author : Stefan Urbanek
    Created: 2005-01-27
    License: GNU LGPL 2.1
*/

#import "EKInspectorPanel.h"

#import <AppKit/NSBox.h>
#import <AppKit/NSNibLoading.h>
#import <AppKit/NSPanel.h>
#import <AppKit/NSPopUpButton.h>
#import <AppKit/NSPopUpButtonCell.h>
#import <AppKit/NSView.h>

#import <Foundation/NSArray.h>
#import <Foundation/NSDictionary.h>
#import <Foundation/NSBundle.h>
#import <Foundation/NSEnumerator.h>
#import <Foundation/NSException.h>
#import <Foundation/NSUserDefaults.h>

#import "EKInspector.h"

EKInspectorPanel *sharedInspectorPanel = nil;

@interface EKInspectorPanelLoader:NSObject
{
    EKInspectorPanel *panel;
}
- (EKInspectorPanel *)panel;
@end

@implementation EKInspectorPanelLoader
- (NSPanel *)panel
{
    return panel;
}
@end

@implementation EKInspectorPanel
+ (EKInspectorPanel *)sharedInspectorPanel
{
    if(!sharedInspectorPanel)
    {
        sharedInspectorPanel = [[EKInspectorPanel alloc] init];
    }
    return sharedInspectorPanel;
}

- init
{
    EKInspectorPanelLoader *loader = [[EKInspectorPanelLoader alloc] init];
    EKInspectorPanel       *panel;

    if(![NSBundle loadNibNamed:@"InspectorPanel" owner:loader])
    {
        [NSException raise:@"EKInspectorPanelException"
                      format:@"Unable to load inspector resources"];
        [self dealloc];
        return nil;
    }

    [self dealloc];
    panel = [loader panel];
    RELEASE(loader);
    [panel setTitle:@"Inspector"];
    [panel updateActiveInspectors];
    
    return panel;
}
- (void)dealloc
{
    RELEASE(inspectorDictionary);
    [super dealloc];
}

- (void)registerInspector:(EKInspector*)anInspector
           withIdentifier:(NSString *)identifier
{
    if(!inspectorDictionary)
    {
        inspectorDictionary = [[NSMutableDictionary alloc] init];
    }
    [anInspector setOwner:self];
    [inspectorDictionary setObject: anInspector forKey:identifier];
}
/*
- removeInspectorWithIdentifier:
- inspectorWithIdentifier:
*/
- (NSString *)selectedInspectorIdentifier
{
    return [[inspectorList selectedItem] representedObject];
}
- (void)setTarget:(id)newTarget owner:(id)anObject
{
    [self setTarget:newTarget];
    [self setTargetOwner:anObject];
}
- (void)setTarget:(id)newTarget
{
    NSEnumerator *enumerator;
    EKInspector  *inspector;
    NSString     *currentInspector = [self selectedInspectorIdentifier];

    if(target == newTarget)
    {
        return;
    }
    
    enumerator = [inspectorDictionary objectEnumerator];
    
    while( (inspector = [enumerator nextObject]) )
    {
        [inspector setTarget:nil];
    }

    ASSIGN(target, newTarget);

    activeInspectors = [target inspectorIdentifiers];
    [self updateActiveInspectors];
    [self selectInspectorWithIdentifier:currentInspector];
}
- (void)updateActiveInspectors
{
    NSPopUpButtonCell *cell;
    NSEnumerator      *enumerator;
    EKInspector       *inspector;
    NSString          *ident;

    enumerator = [activeInspectors objectEnumerator];

    [inspectorList removeAllItems];

    while( (ident = [enumerator nextObject]) )
    {
        inspector = [inspectorDictionary objectForKey:ident];
        
        if(inspector)
        {
            [inspector setTarget:target];
            [inspectorList addItemWithTitle:[inspector title]];
            cell = (NSPopUpButtonCell *)[inspectorList itemWithTitle: [inspector title]];
            [cell setRepresentedObject:ident];
        }
    }
    [inspectorList selectItemAtIndex:0];
    [self changeInspector:nil];
}
- (void)changeInspector:(id)sender
{
    [self selectInspectorWithIdentifier:
            [[inspectorList selectedItem] representedObject]];

}
- (void)selectInspectorWithIdentifier:(NSString *)ident
{
    EKInspector *inspector;
    NSView      *newView;

    inspector = [inspectorDictionary objectForKey:ident];
    newView = [inspector view];

    [inspectorContainerView setContentView:newView];
    [inspectorContainerView setNeedsDisplay:YES];
}
- (void)setTargetOwner:(id)anObject
{
    ASSIGN(targetOwner,anObject);
}
- (id)targetOwner
{
    return targetOwner;
}
- (void)targetChanged
{
    [targetOwner inspectorPanel:self touchedTarget:target];
}

- (void)orderFrontIfVisible
{
    NSUserDefaults *defaults = [NSUserDefaults standardUserDefaults];

    if([defaults boolForKey:@"ShowInspectorPanel"])
    {
        [self makeKeyAndOrderFront:nil];
    }
}
- (void)performClose:(id)sender
{
    NSUserDefaults *defaults = [NSUserDefaults standardUserDefaults];

    [defaults setBool:NO forKey:@"ShowInspectorPanel"];
    [super performClose:sender];
}
- (void)makeKeyAndOrderFront:(id)sender
{
    NSUserDefaults *defaults = [NSUserDefaults standardUserDefaults];

    [defaults setBool:YES forKey:@"ShowInspectorPanel"];
    [super makeKeyAndOrderFront:sender];
}

@end
