// Copyright (C) 2001 Jean-Marc Valin

#ifndef GUIDOCUMENT_H
#define GUIDOCUMENT_H

#include "UIDocument.h"
#include "GUINetPopup.h"
#include "GUINetwork.h"
#include <gnome.h>
#include <pthread.h>

class DocParameterData {
public:

   GtkWidget *optionmenu;
   GtkWidget *optionmenu_menu;
   GtkWidget *combo_entry;
   GtkWidget *entry;
   GtkWidget *label;

   };



class GUIDocument : public UIDocument {
protected:
  
  friend void create_threaded(gchar * str, GUIDocument *doc);
  friend void create_net(gchar * str, GUIDocument *doc);
  friend void create_iter(gchar * str, GUIDocument *doc);

  //signals
  friend void document_change_current_page_event(GtkNotebook *notebook, gint arg1,  GUIDocument *document);
  friend gboolean document_focus_tab_event(GtkNotebook *notebook, GtkNotebookTab arg1, GUIDocument *document);
  friend gboolean document_select_page_event(GtkNotebook *notebook, gboolean arg1, GUIDocument *document);
  friend void document_category_changed_event (GtkEntry *entry, GUIDocument *document);
  friend void document_comments_changed_event (GtkTextBuffer *textbuffer, GUIDocument *document);


   GnomeMDIGenericChild *mdiChild;

   //GtkWidget *view;
   GtkWidget *docproperty;

   
   GtkWidget *label1;
   GtkWidget *vbox2;
   GtkWidget *document_notebook;
   GtkWidget *less2;
   GtkWidget *scrolledwindow1;
   string less_text;

   vector<DocParameterData> params;
public:
   static pthread_mutex_t del_lock;
   static pthread_t runThread;
   static bool isRunning;
   static Network *runningNet;
public:
   GUIDocument(string _name);

   ~GUIDocument();
   
   int closeRequest(bool force=false);

   GnomeMDIGenericChild *getMDIChild() {return mdiChild;}

   GtkWidget *getView() {return vbox2;}

   void add_notebook_network(GUINetwork *net, GtkWidget *child);
  
   void remove_notebook_network(GUINetwork *net, GtkWidget *child);

   void less_print(const string &message);

   void less_print(const char *message);

   void less_clear();

   //void create();

   void save();

   //void createView();

   virtual void load();

   void removeCurrentNet ();

   void renameCurrentNet ();

   UINetwork* getCurrentNet();

   virtual UINetwork *newNetwork(const string &_name, UINetwork::Type type);

   virtual UINetwork *newNetwork(xmlNodePtr _net);

   virtual void setFullPath(const string &fullpath);

   virtual void run();

   void createParamDialog();

   void showParams();

   void changedParams();

   void applyParams();

   void updateSubnet();

   void insertLoadedParam(DocParameterData *param, string type, string value);

   void threadRun();
   
   string getNewNetName(UINetwork::Type type);
   

   friend class GUINetPopup;

   static void threadStop();

  protected:

   virtual void error(char *err);

   GtkWidget *getNotebook() {return document_notebook;}


};


#endif
