/**********************************************************************
 *
 *   FreeDoko a Doppelkopf-Game
 *    
 *   Copyright (C) 2001-2006  by Diether Knof and Borg Enders
 *
 *   This program is free software; you can redistribute it and/or 
 *   modify it under the terms of the GNU General Public License as 
 *   published by the Free Software Foundation; either version 2 of 
 *   the License, or (at your option) any later version.
 *
 *   This program is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *   GNU General Public License for more details. 
 *   You can find this license in the file 'gpl.txt'.
 *
 *   You should have received a copy of the GNU General Public License
 *   along with this program; if not, write to the Free Software
 *   Foundation, Inc., 59 Temple Place, Suite 330, Boston, 
 *   MA  02111-1307  USA
 *
 *  Contact:
 *    Diether Knof dknof@gmx.de
 *    Borg Enders  borg@borgsoft.de
 *
 *********************************************************************/

#include "constants.h"
#include "card.h"

#include "../misc/setting.h"
unsigned const Card::NUMBER_OF_COLORS = 4;
unsigned const Card::NUMBER_OF_TCOLORS = Card::NUMBER_OF_COLORS + 1;


/**
 **
 ** -> result
 **
 ** @param	i	int value to be transformed into a CardColor
 **
 ** @return	DIAMOND     : for input 0
 **		HEART       : for input 1
 **		SPADE       : for input 2
 **		CLUB        : for input 3
 **		NOCARDCOLOR : otherwise
 **
 ** @version	0.5.4
 **
 ** @author	Borg Enders
 **
 ** @todo	remove
 **
 **/
Card::Color
Card::InttoColor(int const i)
{
  DEBUG_CALLING(INFO_CARD && INFO_VALUE,"Card::InttoColor()");

  switch(i) {
  case 0:
    DEBUG_RETURNING(DIAMOND,INFO_CARD && INFO_VALUE,"Card::InttoColor()");
    break;

  case 1:
    DEBUG_RETURNING(HEART,INFO_CARD && INFO_VALUE,"Card::InttoColor()");
    break;

  case 2:
    DEBUG_RETURNING(SPADE,INFO_CARD && INFO_VALUE,"Card::InttoColor()");
    break;

  case 3:
    DEBUG_RETURNING(CLUB,INFO_CARD && INFO_VALUE,"Card::InttoColor()");
    break;

  default:
    DEBUG_ASSERTION(false,
		    "Card::InttoColor(): illegal value");

    break;
  }

  DEBUG_RETURNING(NOCARDCOLOR,INFO_CARD && INFO_VALUE,"Card::InttoColor()");
} // Card::Color Card::InttoColor(int const i)

/**
 **
 ** -> result
 **
 ** @param	color_a	first color
 ** @param	color_b	second color
 **
 ** @return	whether 'color_a' is greater than 'color_b'
 **		(in the order: 'club', 'spade', 'heart', 'diamond'
 **
 ** @version	0.5.4
 **
 ** @author	Diether Knof
 ** @author	Borg Enders
 **
 **/
bool
operator>(Card::Color const& color_a, Card::Color const& color_b)
{
  DEBUG_CALLING(INFO_CARD && INFO_VALUE,
		"operator>(color_a, color_b)");

  switch (color_a) {
  case Card::CLUB:
    DEBUG_RETURNING(( (color_b == Card::SPADE) ||
		      (color_b == Card::HEART) ||
		      (color_b == Card::DIAMOND) ),
		    INFO_CARD && INFO_VALUE,
		    "operator>(color_a, color_b)");
    break;
  case Card::SPADE:
    DEBUG_RETURNING(((color_b == Card::HEART) ||
		     (color_b == Card::DIAMOND) ),
		    INFO_CARD && INFO_VALUE,
		    "operator>(color_a, color_b)");
    break;
  case Card::HEART:
    DEBUG_RETURNING((color_b == Card::DIAMOND) ,
		    INFO_CARD && INFO_VALUE,
		    "operator>(color_a, color_b)");
    break;
  case Card::DIAMOND:
    DEBUG_RETURNING(false ,
		    INFO_CARD && INFO_VALUE,
		    "operator>(color_a, color_b)");
    break;
  default:
    DEBUG_ASSERTION(false,
		    "operator>(color_a, color_b): illegal value");

    break;
  } // switch (color_a)

  DEBUG_RETURNING(false ,
		  INFO_CARD && INFO_VALUE,
		  "operator>(color_a, color_b)");
} // bool operator>(Card::Color const& color_a, Card::Color const& color_b)

/**
 **
 ** -> result
 **
 ** @param	tcolor	card tcolor
 **
 ** @return	name of the tcolor
 **
 ** @version	0.5.4
 **
 ** @author	Diether Knof
 **
 **/
string
name(Card::TColor const& tcolor)
{
  DEBUG_CALLING(INFO_CARD && INFO_BASISTYPES && INFO_NAME,
		"string name(Card::TColor const& tcolor)");

  string name;

  switch(tcolor) {
  case Card::CLUB:
    name = "club";
    break;
  case Card::SPADE:
    name = "spade";
    break;
  case Card::HEART:
    name = "heart";
    break;
  case Card::DIAMOND:
    name = "diamond";
    break;
  case Card::TRUMP:
    name = "trump";
    break;
  case Card::NOCARDCOLOR:
    name = "no card color";
    break;
  } // switch(tcolor)

  DEBUG_RETURNING(name,
		  INFO_CARD && INFO_BASISTYPES && INFO_NAME,
		  "string name(Card::TColor const& tcolor)");
} // string name(Card::TColor const& tcolor)

/**
 **
 ** -> result
 **
 ** @param	color_name	name of the color
 **
 ** @return	color 'name'
 **
 ** @version	0.5.4
 **
 ** @author	Diether Knof
 **
 **/
Card::Color
Card::color(string const& color_name)
{
  DEBUG_CALLING(INFO_CARD && INFO_BASISTYPES && INFO_NAME,
		"Card::Color color(color_name)");

  Card::Color color = Card::NOCARDCOLOR;
  if (color_name == ::name(Card::CLUB))
    color = Card::CLUB;
  else if (color_name == ::name(Card::SPADE))
    color = Card::SPADE;
  else if (color_name == ::name(Card::HEART))
    color = Card::HEART;
  else if (color_name == ::name(Card::DIAMOND))
    color = Card::DIAMOND;
  else
    DEBUG_ASSERTION(false,
		    "Card::color(color_name):\n"
		    "  color '" << color_name << "' unknown");

  DEBUG_RETURNING(color,
		  INFO_CARD && INFO_BASISTYPES && INFO_NAME,
		  "Card::Color color(color_name)");
} // static Card::Color Card::color(string const& color_name)

/**
 **
 ** writes the card color in the output stream
 **
 ** @param	ostr	output stream
 ** @param	tcolor	card color
 **
 ** @return	output stream
 **
 ** @version	0.5.4
 **
 ** @author	Diether Knof
 **
 **/
ostream&
operator<<(ostream& ostr, Card::TColor const& tcolor)
{
  DEBUG_CALLING(INFO_CARD && INFO_BASISTYPES && INFO_IO,
		"ostream& operator<<(ostr, tcolor)");

  ostr << name(tcolor);

  DEBUG_RETURNING(ostr,
		  INFO_CARD && INFO_BASISTYPES && INFO_IO,
		  "ostream& operator<<(ostr, tcolor)");
} // ostream& operator<<(ostream& ostr, Card::TColor const& tcolor);

/**
 **
 ** read the card color out of the stream
 **
 ** @param	istr	input stream
 ** @param	color	card color
 **
 ** @return	output stream
 **
 ** @version	0.5.4
 **
 ** @author	Diether Knof
 **
 **/
istream&
operator>>(istream& istr, Card::Color& color)
{
  DEBUG_CALLING(INFO_CARD && INFO_BASISTYPES && INFO_IO,
		"ostream& operator<<(ostr, color)");

  string color_name;
  istr >> color_name;
  color = Card::color(color_name);

  DEBUG_RETURNING(istr,
		  INFO_CARD && INFO_BASISTYPES && INFO_IO,
		  "ostream& operator<<(ostr, color)");
} // istream& operator>>(istream& istr, Card::Color& color);
