/**********************************************************************
 *
 *   FreeDoko a Doppelkopf-Game
 *    
 *   Copyright (C) 2001-2006  by Diether Knof and Borg Enders
 *
 *   This program is free software; you can redistribute it and/or 
 *   modify it under the terms of the GNU General Public License as 
 *   published by the Free Software Foundation; either version 2 of 
 *   the License, or (at your option) any later version.
 *
 *   This program is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *   GNU General Public License for more details. 
 *   You can find this license in the file 'gpl.txt'.
 *
 *   You should have received a copy of the GNU General Public License
 *   along with this program; if not, write to the Free Software
 *   Foundation, Inc., 59 Temple Place, Suite 330, Boston, 
 *   MA  02111-1307  USA
 *
 *  Contact:
 *    Diether Knof dknof@gmx.de
 *    Borg Enders  borg@borgsoft.de
 *
 *********************************************************************/

#include "constants.h"

#ifdef USE_UI_GTKMM

#include "announcement_info.h"
#include "table.h"
#include "ui.h"
#include "translations.h"
#include "icons.h"

#include "../../party/rule.h"
#include "../../game/game.h"
#include "../../player/human/human.h"
#include "../../card/trick.h"
#include "../../misc/setting.h"

#include "widgets/stock_button.h"
#include <gtkmm/stock.h>
#include <gtkmm/box.h>
#include <gtkmm/image.h>
#include <gtkmm/label.h>

namespace UI_GTKMM_NS {

  /**
   **
   ** Constructor
   **
   ** @param	table	the table
   **
   ** @return	-
   ** 
   ** @author	Diether Knof
   **
   ** @version	0.6.6
   **
   **/
  AnnouncementInfo::AnnouncementInfo(Table* const table) :
    GameinfoDialog(table),
  icon(NULL),
  text(NULL),
  reply(NULL),
  player(NULL)
  {
    return ;
  } // AnnouncementInfo::AnnouncementInfo(Table* const table)

  /**
   **
   ** Destruktor
   **
   ** @param	-
   **
   ** @return	-
   ** 
   ** @author	Diether Knof
   **
   ** @version	0.6.1
   **
   **/
  AnnouncementInfo::~AnnouncementInfo()
  {
    return ;
  } // AnnouncementInfo::~AnnouncementInfo()

  /**
   **
   ** init the dialog
   **
   ** @param	-
   **
   ** @return	-
   ** 
   ** @author	Diether Knof
   **
   ** @version	0.6.1
   **
   **/
  void
    AnnouncementInfo::init()
    {
      this->GameinfoDialog::init();

      this->ui->translations->add(*this,
				    ::translation("announcement"));


      this->icon = this->ui->icons->new_managed_image();
      this->text = Gtk::manage(new Gtk::Label("Player announces 'announcement'."));
      this->ui->translations->add(*(this->text),
				    ::translation("announcement"));

      this->close_button->show_all();

      Gtk::VBox* vbox = Gtk::manage(new Gtk::VBox(false, 2 ex));
      vbox->set_border_width(2 ex);

      vbox->add(*(this->icon));
      vbox->add(*(this->text));

      this->get_vbox()->add(*vbox);

      { // show 'announcement reply' button
	this->reply = Gtk::manage(new Gtk::StockButton(Gtk::Stock::OK,
						       "announcement reply"));
	this->ui->translations->add(*(this->reply),
				      ::translation("Announcement::reply"));

	this->add_action_widget(*(this->reply), Gtk::RESPONSE_ACCEPT);
	this->get_action_area()->reorder_child(*(this->close_button), -1);

	this->reply->signal_clicked().connect(sigc::mem_fun(*this, &GameinfoDialog::close));
	this->reply->signal_clicked().connect(sigc::mem_fun(*this, &AnnouncementInfo::reply_event));
      } // show 'announcement reply' button

      this->show_all_children();

      return ;
    } // void AnnouncementInfo::init()

  /**
   **
   ** event: make a reply
   **
   ** @param	-
   **
   ** @return	-
   ** 
   ** @author	Diether Knof
   **
   ** @version	0.6.4
   **
   **/
  void
    AnnouncementInfo::reply_event()
    {
      DEBUG_ASSERTION(this->player->game().human_player(),
		      "UI_GTKMM_NS::AnnouncementInfo::reply_event():\n"
		      "  Found no human player.");

      this->ui->game().announcement_make(ANNOUNCEMENT::to_reply(this->player->announcement()),
					 *(this->ui->game().human_player()));


      return ;
    } // void AnnouncementInfo::reply_event()

  /**
   **
   ** show the window
   **
   ** @param	player	player who has made the announcement
   **
   ** @return	-
   ** 
   ** @author	Diether Knof
   **
   ** @version	0.6.6
   **
   **/
  void
    AnnouncementInfo::show_information(Player const& player)
    {
      if (!this->is_realized())
	this->realize();

      // Check whether the announcement was made because the trick
      // contains thirty points (-> rule).
      bool const duty_announcement_30
	= (   player.game().rule()(Rule::ANNOUNCEMENT_FIRST_TRICK_THIRTY_POINTS)
	   && (player.game().real_trick_current_no() == 0)
	   && player.game().trick_current().isfull()
	   && (player.game().trick_current().points() >= 30)
	   && player.is_same(player.game().trick_current().winnerplayer())
	   && (player.announcement() == ANNOUNCEMENT::NO120)
	   && (   !player.game().rule()(Rule::ANNOUNCEMENT_FIRST_TRICK_THIRTY_POINTS_ONLY_FIRST)
	       || (player.game().announcement_of_team(::opposite(player.team()))
		   == ANNOUNCEMENT::NOANNOUNCEMENT)
	      ) );
      if (   (player.type() == Player::HUMAN)
	  && !duty_announcement_30)
	return ;

      this->player = &player;

      if (player.announcement() == ANNOUNCEMENT::NO120)
	this->ui->translations->change(*this,
				       ::translation(player.team()));

      else
	this->ui->translations->change(*this,
				       ::translation(player.announcement()
						    ));


      if (player.announcement() == ANNOUNCEMENT::NO120) {
	this->ui->icons->change_managed(this->icon, player.team());
	if (duty_announcement_30) {
	  this->ui->translations->change(*this->text,
					 ::translation("%splayer% announces '%tannouncement%' (duty 30).",
						       player.name(),
						       ::translation(player.team())
						      ));
	} else {
	  this->ui->translations->change(*this->text,
					 ::translation("%splayer% announces '%tannouncement%'.",
						       player.name(),
						       ::translation(player.team())
						      ));
	}

      } else {
	this->ui->icons->change_managed(this->icon, player.announcement());
	this->ui->translations->change(*this->text,
				       ::translation("%splayer% announces '%tannouncement%'.",
						     player.name(),
						     ::translation(player.announcement())
						    ));
      }

      {
	Game const& game = player.game();
	// a human can announce 
	if (game.rule()(Rule::ANNOUNCEMENT_REPLY)
	    && (game.humanno() == 1)
	    && game.announcement_valid(ANNOUNCEMENT::REPLY,
				       *(game.human_player()))) {
	  this->reply->show();
	  this->ui->translations->change(*(this->reply),
					 ::translation(ANNOUNCEMENT::to_reply(player.announcement())
						      ));
	} else { // if !(human can reply)
	  this->reply->hide();
	} // if !(human can reply)
      }

      this->GameinfoDialog::show_information(::setting(Setting::SHOW_ANNOUNCEMENT_WINDOW),
					     ::setting(Setting::CLOSE_ANNOUNCEMENT_WINDOW_AUTOMATICALLY),
					     ::setting(Setting::ANNOUNCEMENT_WINDOW_CLOSE_DELAY));

      this->ui->icons->change_managed(this->icon, Icons::NONE);
      this->player = NULL;

      return ;
    } // void AnnouncementInfo::show_information(Player const& player)

  /**
   **
   ** 'player' has made an announcement
   **
   ** @param	player	the player who has made the announcement
   **
   ** @return	-
   ** 
   ** @author	Diether Knof
   **
   ** @version	0.6.4
   **
   **/
  void
    AnnouncementInfo::announcement_made(Player const& player)
    {
      if (this->reply
	  && this->reply->get_parent()) {
	this->reply->hide();
      }

      return ;
    } // void AnnouncementInfo::announcement_made(Player const& player)

  /**
   **
   ** the name of 'player' has changed
   **
   ** @param	player	the player whose name has changed
   **
   ** @return	-
   ** 
   ** @author	Diether Knof
   **
   ** @version	0.6.1
   **
   **/
  void
    AnnouncementInfo::name_changed(Player const& player)
    {
      if (&player == this->player) {
	if (player.announcement() == ANNOUNCEMENT::NO120) {
	  this->ui->translations->change(*(this->text),
					 ::translation("%splayer% announces '%tannouncement%'.",
						       player.name(),
						       ::translation(player.team())
						      ));

	} else {
	  this->ui->translations->change(*(this->text),
					 ::translation("%splayer% announces '%tannouncement%'.",
						       player.name(),
						       ::translation(player.announcement())
						      ));
	}
      } // if (&player == this->player)

      return ;
    } // void AnnouncementInfo::name_changed(Player const& player)

} // namespace UI_GTKMM_NS

#endif // #ifdef USE_UI_GTKMM
