/**********************************************************************
 *
 *   FreeDoko a Doppelkopf-Game
 *    
 *   Copyright (C) 2001-2006  by Diether Knof and Borg Enders
 *
 *   This program is free software; you can redistribute it and/or 
 *   modify it under the terms of the GNU General Public License as 
 *   published by the Free Software Foundation; either version 2 of 
 *   the License, or (at your option) any later version.
 *
 *   This program is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *   GNU General Public License for more details. 
 *   You can find this license in the file 'gpl.txt'.
 *
 *   You should have received a copy of the GNU General Public License
 *   along with this program; if not, write to the Free Software
 *   Foundation, Inc., 59 Temple Place, Suite 330, Boston, 
 *   MA  02111-1307  USA
 *
 *  Contact:
 *    Diether Knof dknof@gmx.de
 *    Borg Enders  borg@borgsoft.de
 *
 *********************************************************************/

#include "constants.h"

#ifdef USE_UI_GTKMM

#include "gameinfo_dialog.h"
#include "table.h"
#include "ui.h"
#include "translations.h"
#include "main_window.h"

#include "widgets/stock_button.h"
#include <gtkmm/stock.h>
#include <gtkmm/button.h>
#include <gtkmm/label.h>
#include <gtkmm/main.h>
#include <gdk/gdkkeysyms.h>

namespace UI_GTKMM_NS {

  /**
   **
   ** Constructor
   **
   ** @param	table			the table
   **
   ** @return	-
   ** 
   ** @author	Diether Knof
   **
   ** @version	0.6.3
   **
   **/
  GameinfoDialog::GameinfoDialog(Table* const table) :
    Base(table),
  Gtk::StickyDialog("Gameinfo", *table->ui->main_window, false),
  close_button(NULL),
    timeout_connection()
  {
    this->ui->add_window(*this);

    this->signal_realize().connect(sigc::mem_fun(*this,
					      &GameinfoDialog::init));

    return ;
  } // GameinfoDialog::GameinfoDialog(Table* const table)

  /**
   **
   ** Destruktor
   **
   ** @param	-
   **
   ** @return	-
   ** 
   ** @author	Diether Knof
   **
   ** @version	0.6.1
   **
   **/
  GameinfoDialog::~GameinfoDialog()
  {
    return ;
  } // GameinfoDialog::~GameinfoDialog()

  /**
   **
   ** init the dialog
   **
   ** @param	-
   **
   ** @return	-
   ** 
   ** @author	Diether Knof
   **
   ** @version	0.6.1
   **
   **/
  void
    GameinfoDialog::init()
    {
      this->set_icon(this->ui->icon);

      this->set_skip_taskbar_hint();

      this->close_button
	= Gtk::manage(new Gtk::StockButton(Gtk::Stock::CLOSE, "close"));
      this->ui->translations->add(*this->close_button,
				    ::translation("close"));
      this->add_action_widget(*this->close_button, Gtk::RESPONSE_CLOSE);

      this->close_button->grab_default();

      this->close_button->signal_clicked().connect(sigc::mem_fun(*this, &GameinfoDialog::close));

      this->show_all_children();
      {
	int x, y;
	this->table().get_window()->get_origin(x, y);
	this->move(x, y);
      }

      return ;
    } // void GameinfoDialog::init()

  /**
   **
   ** -> result
   **
   ** @param	-
   **
   ** @return	the table
   **
   ** @version	0.6.8
   **
   ** @author	Diether Knof
   **
   **/
  Table&
    GameinfoDialog::table()
    {
      return *dynamic_cast<Table*>(this->parent);
    } // Table& GameinfDialog::table()

  /**
   **
   ** show the information
   **
   ** @param	show			whether to show the window
   ** @param	close_automatically	whether to close the window automatically
   ** @param	close_delay		the time (in tenth of seconds) to wait before closing the window
   **
   ** @return	-
   ** 
   ** @author	Diether Knof
   **
   ** @version	0.6.1
   **
   **/
  void
    GameinfoDialog::show_information(bool const show,
				     bool const close_automatically,
				     unsigned const close_delay)
    {
      if (show) {

	this->present();


	if (close_automatically)
	  this->timeout_connection
	    = Glib::signal_timeout().connect(sigc::slot0<bool>(sigc::mem_fun(*this, &GameinfoDialog::on_timeout)),
					     close_delay);

	while (!this->ui->thrower
	       && (this->is_visible()))
	  Gtk::Main::iteration();

	this->close();
      } // if (show)

      return ;
    } // void GameinfoDialog::show_information(bool const show, bool const close_automatically, unsigned const close_delay)

  /**
   **
   ** show the information and close it on a click
   **
   ** @param	-
   **
   ** @return	-
   ** 
   ** @author	Diether Knof
   **
   ** @version	0.6.1
   **
   **/
  void
    GameinfoDialog::show_information()
    {
      this->show_information(true, false, UINT_MAX);

      return ;
    } // void GameinfoDialog::show_information()

  /**
   **
   ** the name of 'player' has changed
   **
   ** @param	player	the player whose name has changed
   **
   ** @return	-
   ** 
   ** @author	Diether Knof
   **
   ** @version	0.6.1
   **
   **/
  void
    GameinfoDialog::name_changed(Player const& player)
    {
      return ;
    } // void GameinfoDialog::name_changed(Player const& player)

  /**
   **
   ** hide the window
   **
   ** @param	-
   **
   ** @return	-
   ** 
   ** @author	Diether Knof
   **
   ** @version	0.6.1
   **
   **/
  void
    GameinfoDialog::close()
    {
      if (this->timeout_connection)
	this->timeout_connection.disconnect();

      this->hide();

      return ;
    } // void GameinfoDialog::close()

  /**
   **
   ** the timeout event:
   ** close the window and exit the main loop
   **
   ** @param	-
   **
   ** @return	false (to stop the timeout event)
   ** 
   ** @author	Diether Knof
   **
   ** @version	0.6.1
   **
   **/
  bool
    GameinfoDialog::on_timeout()
    {
      this->close();
      if (Gtk::Main::level() > 0)
	Gtk::Main::quit();

      return false;
    } // bool GameinfoDialog::on_timeout()

  /**
   **
   ** a key has been pressed
   **
   ** @param	key	the key
   **
   ** @return	whether the key was accepted
   **
   ** @version	0.6.1
   **
   ** @author	Diether Knof
   **
   **/
  bool
    GameinfoDialog::on_key_press_event(GdkEventKey* key)
    {
      bool managed = false;

      if ((key->state & ~GDK_SHIFT_MASK) == 0) {
	switch (key->keyval) {
	case GDK_Escape: // close the window
	  managed = true;
	  this->close();
	  break;
	} // switch (key->keyval)
      } // if ((key->state & ~GDK_SHIFT_MASK) == 0)

      return (managed
	      || this->StickyDialog::on_key_press_event(key)
	      || this->ui->key_press(key));
    } // bool GameinfoDialog::on_key_press_event(GdkEventKey* key)

  /**
   ** the mouse was clicked on the table
   ** close the window
   **
   ** @param	-
   **
   ** @return	-
   **
   ** @version	0.6.9
   **
   ** @author	Diether Knof
   **
   **/
  void
    GameinfoDialog::mouse_click_on_table()
    {
      this->close();
      return ;
    } // void GameinfoDialog::mouse_click_on_table()

} // namespace UI_GTKMM_NS

#endif // #ifdef USE_UI_GTKMM
