/**********************************************************************
 *
 *   FreeDoko a Doppelkopf-Game
 *    
 *   Copyright (C) 2001-2006  by Diether Knof and Borg Enders
 *
 *   This program is free software; you can redistribute it and/or 
 *   modify it under the terms of the GNU General Public License as 
 *   published by the Free Software Foundation; either version 2 of 
 *   the License, or (at your option) any later version.
 *
 *   This program is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *   GNU General Public License for more details. 
 *   You can find this license in the file 'gpl.txt'.
 *
 *   You should have received a copy of the GNU General Public License
 *   along with this program; if not, write to the Free Software
 *   Foundation, Inc., 59 Temple Place, Suite 330, Boston, 
 *   MA  02111-1307  USA
 *
 *  Contact:
 *    Diether Knof dknof@gmx.de
 *    Borg Enders  borg@borgsoft.de
 *
 *********************************************************************/

#include "constants.h"

#ifdef USE_UI_GTKMM

#include "genscher_info.h"
#include "table.h"
#include "ui.h"
#include "translations.h"
#include "icons.h"

#include "../../game/game.h"
#include "../../player/player.h"
#include "../../misc/setting.h"

#include <gtkmm/box.h>
#include <gtkmm/image.h>
#include <gtkmm/label.h>

namespace UI_GTKMM_NS {

  /**
   **
   ** Constructor
   **
   ** @param	table		the table
   **
   **
   ** @return	-
   ** 
   ** @author	Diether Knof
   **
   ** @version	0.6.6
   **
   **/
  GenscherInfo::GenscherInfo(Table* const table) :
    GameinfoDialog(table),
  icon(NULL),
  text(NULL),
  genscher(NULL),
  partner(NULL)
  {
    return ;
  } // GenscherInfo::GenscherInfo(Table* const table)

  /**
   **
   ** Destruktor
   **
   ** @param	-
   **
   ** @return	-
   ** 
   ** @author	Diether Knof
   **
   ** @version	0.6.1
   **
   **/
  GenscherInfo::~GenscherInfo()
  {
    return ;
  } // GenscherInfo::~GenscherInfo()

  /**
   **
   ** init the dialog
   **
   ** @param	-
   **
   ** @return	-
   ** 
   ** @author	Diether Knof
   **
   ** @version	0.6.1
   **
   **/
  void
    GenscherInfo::init()
    {
      this->GameinfoDialog::init();

      this->ui->translations->add(*this,
				    ::translation("~genscher"));

      this->icon = this->ui->icons->new_managed_image();
      this->text = Gtk::manage(new Gtk::Label("Genscher: Player chooses partner."));
      this->ui->translations->add(*(this->text),
				    ::translation("Genscher: %splayer% chooses %spartner%.",
						 "genscher",
						 "player"));

      Gtk::VBox* vbox = Gtk::manage(new Gtk::VBox(false, 2 ex));
      vbox->set_border_width(2 ex);

      vbox->add(*(this->icon));
      vbox->add(*(this->text));

      this->get_vbox()->add(*vbox);

      this->show_all_children();

      return ;
    } // void GenscherInfo::init()

  /**
   **
   ** show the window
   **
   ** @param	genscher	the player who has the genscher
   ** @param	partner		the new partner
   **
   ** @return	-
   ** 
   ** @author	Diether Knof
   **
   ** @version	0.6.6
   **
   **/
  void
    GenscherInfo::show_information(Player const& genscher,
				   Player const& partner)
    {
      this->genscher = &genscher;
      this->partner = &partner;
      if (!this->is_realized())
	this->realize();
      
      this->ui->icons->change_managed(this->icon, this->partner->game().type());

      this->name_changed(genscher);
      this->name_changed(partner);

      this->GameinfoDialog::show_information(::setting(Setting::SHOW_GENSCHER_WINDOW),
					     ::setting(Setting::CLOSE_GENSCHER_WINDOW_AUTOMATICALLY),
					     ::setting(Setting::GENSCHER_WINDOW_CLOSE_DELAY));

      this->ui->icons->change_managed(this->icon, Icons::NONE);
      this->genscher = NULL;
      this->partner = NULL;

      return ;
    } // void GenscherInfo::show_information(Player const& genscher, Player const& partner)

  /**
   **
   ** the name of 'player' has changed
   **
   ** @param	player	the player whose name has changed
   **
   ** @return	-
   ** 
   ** @author	Diether Knof
   **
   ** @version	0.6.1
   **
   **/
  void
    GenscherInfo::name_changed(Player const& player)
    {
      if ((player.is_same(*(this->genscher)))
	  || (player.is_same(*(this->partner)))) {
	this->ui->translations->change(*(this->text),
				     ::translation("Genscher: %splayer% chooses %spartner%.",
						  this->genscher->name(),
						  this->partner->name()
						 ));
      }

      return ;
    } // void GenscherInfo::name_changed(Player const& player)

} // namespace UI_GTKMM_NS

#endif // #ifdef USE_UI_GTKMM
