/**********************************************************************
 *
 *   FreeDoko a Doppelkopf-Game
 *    
 *   Copyright (C) 2001-2006  by Diether Knof and Borg Enders
 *
 *   This program is free software; you can redistribute it and/or 
 *   modify it under the terms of the GNU General Public License as 
 *   published by the Free Software Foundation; either version 2 of 
 *   the License, or (at your option) any later version.
 *
 *   This program is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *   GNU General Public License for more details. 
 *   You can find this license in the file 'gpl.txt'.
 *
 *   You should have received a copy of the GNU General Public License
 *   along with this program; if not, write to the Free Software
 *   Foundation, Inc., 59 Temple Place, Suite 330, Boston, 
 *   MA  02111-1307  USA
 *
 *  Contact:
 *    Diether Knof dknof@gmx.de
 *    Borg Enders  borg@borgsoft.de
 *
 *********************************************************************/

#include "constants.h"

#ifdef USE_UI_GTKMM

#include "marriage_info.h"
#include "table.h"
#include "ui.h"
#include "translations.h"
#include "icons.h"

#include "../../game/game.h"
#include "../../player/player.h"
#include "../../misc/setting.h"

#include <gtkmm/box.h>
#include <gtkmm/image.h>
#include <gtkmm/label.h>

namespace UI_GTKMM_NS {

  /**
   **
   ** Constructor
   **
   ** @param	table		the table
   **
   **
   ** @return	-
   ** 
   ** @author	Diether Knof
   **
   ** @version	0.6.6
   **
   **/
  MarriageInfo::MarriageInfo(Table* const table) :
    GameinfoDialog(table),
  icon(NULL),
  text(NULL),
  bridegroom(NULL),
  bride(NULL)
  {
    return ;
  } // MarriageInfo::MarriageInfo(Table* const table, Player const& bridegroom, Player const& bride)

  /**
   **
   ** Destruktor
   **
   ** @param	-
   **
   ** @return	-
   ** 
   ** @author	Diether Knof
   **
   ** @version	0.6.1
   **
   **/
  MarriageInfo::~MarriageInfo()
  {
    return ;
  } // MarriageInfo::~MarriageInfo()

  /**
   ** init the dialog
   **
   ** @param	-
   **
   ** @return	-
   ** 
   ** @author	Diether Knof
   **
   ** @version	0.7.1
   **/
  void
    MarriageInfo::init()
    {
      this->GameinfoDialog::init();

      this->ui->translations->add(*this, ::translation(GAMETYPE::MARRIAGE));

      this->icon = this->ui->icons->new_managed_image();
      this->text = Gtk::manage(new Gtk::Label("Player marriages bride."));
      if (*this->bridegroom == *this->bride)
	this->ui->translations->add(*this->text,
				      ::translation("%splayer% has found no bride.",
						   this->bridegroom->name()
						  ));
      else
	this->ui->translations->add(*this->text,
				      ::translation("%splayer% marries %sbride%.",
						   this->bridegroom->name().c_str(),
						   this->bride->name()
						  ));


      Gtk::VBox* vbox = Gtk::manage(new Gtk::VBox(false, 2 ex));
      vbox->set_border_width(2 ex);

      vbox->add(*this->icon);
      vbox->add(*this->text);

      this->get_vbox()->add(*vbox);

      this->show_all_children();

      return ;
    } // void MarriageInfo::init()

  /**
   **
   ** show the window
   **
   ** @param	bridegroom	the player with the marriage
   ** @param	bride		the partner
   **
   ** @return	-
   ** 
   ** @author	Diether Knof
   **
   ** @version	0.6.6
   **
   **/
  void
    MarriageInfo::show_information(Player const& bridegroom,
				   Player const& bride)
    {
      this->bridegroom = &bridegroom;
      this->bride = &bride;
      if (!this->is_realized())
	this->realize();

      this->ui->icons->change_managed(this->icon,
				      this->bridegroom->game().marriage_selector());

      this->name_changed(bridegroom);
      this->name_changed(bride);

      this->GameinfoDialog::show_information(::setting(Setting::SHOW_MARRIAGE_WINDOW),
					     ::setting(Setting::CLOSE_MARRIAGE_WINDOW_AUTOMATICALLY),
					     ::setting(Setting::MARRIAGE_WINDOW_CLOSE_DELAY));

      this->ui->icons->change_managed(this->icon, Icons::NONE);
      this->bridegroom = NULL;
      this->bride = NULL;

      return ;
    } // void MarriageInfo::show_information(Player const& bridegroom, Player const& bride)


  /**
   **
   ** the name of 'player' has changed
   **
   ** @param	player	the player whose name has changed
   **
   ** @return	-
   ** 
   ** @author	Diether Knof
   **
   ** @version	0.6.1
   **
   **/
  void
    MarriageInfo::name_changed(Player const& player)
    {
      if ((player.is_same(*(this->bridegroom)))
	  || (player.is_same(*(this->bride)))) {
	if (*(this->bridegroom) == *(this->bride))
	  this->ui->translations->change(*(this->text),
				       ::translation("%splayer% has found no bride.",
						    this->bridegroom->name()
						   ));
	else
	  this->ui->translations->change(*(this->text),
				       ::translation("%splayer% marries %sbride%.",
						    this->bridegroom->name().c_str(),
						    this->bride->name()
						   ));
      }

      return ;
    } // void MarriageInfo::name_changed(Player const& player)

  } // namespace UI_GTKMM_NS

#endif // #ifdef USE_UI_GTKMM
