/**********************************************************************
 *
 *   FreeDoko a Doppelkopf-Game
 *    
 *   Copyright (C) 2001-2006  by Diether Knof and Borg Enders
 *
 *   This program is free software; you can redistribute it and/or 
 *   modify it under the terms of the GNU General Public License as 
 *   published by the Free Software Foundation; either version 2 of 
 *   the License, or (at your option) any later version.
 *
 *   This program is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *   GNU General Public License for more details. 
 *   You can find this license in the file 'gpl.txt'.
 *
 *   You should have received a copy of the GNU General Public License
 *   along with this program; if not, write to the Free Software
 *   Foundation, Inc., 59 Temple Place, Suite 330, Boston, 
 *   MA  02111-1307  USA
 *
 *  Contact:
 *    Diether Knof dknof@gmx.de
 *    Borg Enders  borg@borgsoft.de
 *
 *********************************************************************/

#include "constants.h"

#ifdef USE_UI_GTKMM

#include "trick.h"
#include "table.h"

#include "../../party/party.h"
#include "../../game/game.h"
#include "../../card/trick.h"
#include "../../player/player.h"

namespace UI_GTKMM_NS {

  /**
   **
   ** Constructor
   **
   ** @param	-
   **
   ** @return	-
   ** 
   ** @author	Diether Knof
   **
   ** @version	0.6.1
   **
   **/
  Trick::Trick(Table* const table) :
    TrickDrawing(table)
    {
      return ;
    } // Trick::Trick(Table* const table)

  /**
   **
   ** Destruktor
   **
   ** @param	-
   **
   ** @return	-
   ** 
   ** @author	Diether Knof
   **
   ** @version	0.6.1
   **
   **/
  Trick::~Trick()
  {
    return ;
  } // Trick::~Trick()

  /**
   **
   ** -> result
   **
   ** @param	-
   **
   ** @return	the table
   **
   ** @version	0.6.1
   **
   ** @author	Diether Knof
   **
   **/
  Table&
    Trick::table()
    {
      return static_cast<Table&>(*(this->parent));
    } // Table& Trick::table()

  /**
   **
   ** -> result
   **
   ** @param	-
   **
   ** @return	the table
   **
   ** @version	0.6.1
   **
   ** @author	Diether Knof
   **
   **/
  Table const&
    Trick::table() const
    {
      return static_cast<Table&>(*(this->parent));
    } // Table const& Trick::table() const

  /**
   **
   ** draws the trick
   **
   ** @param     update	whether to update the area
   **
   ** @return    -
   ** 
   ** @author    Diether Knof
   **
   ** @version   0.6.1
   **
   ** @todo      in a network play: if one has closed but not the other players, make the cards gray
   **/
  void
    Trick::draw(bool const update)
    {
      if ( ((::game_status >= GAMESTATUS::GAME_PLAY)
	    && ((::game_status < GAMESTATUS::GAME_FINISHED)
		|| (this->table().in_game_review()) ) ) ) {
	this->set_center(Gdk::Point(this->table().width() / 2,
				    this->table().height() / 2));

	if (this->table().in_game_review())
	  this->set_trick(this->table().game_review_trick());
	else
	  this->set_trick(::party.game().trick_current());

	if (update)
	  this->table().clear(this->outline());

	// only show the trick if it is in the middle
	// (and not in the trickpile)
	if (this->trick
	    && (!this->trick->isfull()
		|| this->trick->winnerplayer().trickpile().empty()
		|| (this->trick->winnerplayer().trickpile().back()->no()
		    < this->trick->no())
		|| this->table().in_game_review()))
	  this->TrickDrawing::draw(this->table().pixmap);

	if (update)
	  this->table().update(this->outline());

      } // if (GAME_RESERVATION <= game_status < GAME_FINISHED)

      return ;
    } // void Trick::draw(bool const update = true)

} // namespace UI_GTKMM_NS

#endif // #ifdef USE_UI_GTKMM
