/**********************************************************************
 *
 *   FreeDoko a Doppelkopf-Game
 *    
 *   Copyright (C) 2001-2006  by Diether Knof and Borg Enders
 *
 *   This program is free software; you can redistribute it and/or 
 *   modify it under the terms of the GNU General Public License as 
 *   published by the Free Software Foundation; either version 2 of 
 *   the License, or (at your option) any later version.
 *
 *   This program is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *   GNU General Public License for more details. 
 *   You can find this license in the file 'gpl.txt'.
 *
 *   You should have received a copy of the GNU General Public License
 *   along with this program; if not, write to the Free Software
 *   Foundation, Inc., 59 Temple Place, Suite 330, Boston, 
 *   MA  02111-1307  USA
 *
 *  Contact:
 *    Diether Knof dknof@gmx.de
 *    Borg Enders  borg@borgsoft.de
 *
 **********************************************************************/

#include "constants.h"

#ifdef USE_UI_GTKMM

#include "utils.h"

#include <gtkmm/togglebutton.h>
namespace UI_GTKMM_NS {

  /**
   **
   ** -> result
   **
   ** @param	color	the color
   **
   ** @return	the name of the color
   **
   ** @version	0.5.4
   **
   ** @author	Diether Knof
   **
   **/
  string
    colorname(Gdk::Color const color)
  {
      ostringstream color_str;
      color_str << '#' << setfill('0')
	<< hex << setw(4) << color.get_red()
	<< hex << setw(4) << color.get_green()
	<< hex << setw(4) << color.get_blue()
	<< ends;

      return color_str.str();
  } // string colorname(Gdk::Colo const color)

#ifdef OUTDATED
  // see 'widgets/pixbuf_rotations.*'
  /**
   **
   ** loads the graphic from the file and rotates it
   **
   ** @param	filename	the file to load from
   **
   ** @return	the rotations of the image
   **
   ** @version	0.5.4
   **
   ** @author	Diether Knof
   **
   **/
  vector<Glib::RefPtr<Gdk::Pixbuf> >
    load_pixbuf_with_rotations(string const filename)
  {
      vector<Glib::RefPtr<Gdk::Pixbuf> > pixbuf;

      Glib::RefPtr<Gdk::Pixbuf> pixbuf_orig
	= Gdk::Pixbuf::create_from_file(filename);

      int const width = pixbuf_orig->get_width();
      int const height = pixbuf_orig->get_height();

      { // UP
	pixbuf.push_back(pixbuf_orig);
      } // UP
      { // DOWN
	Glib::RefPtr<Gdk::Pixbuf> pixbuf_tmp
	  = Gdk::Pixbuf::create(pixbuf_orig->get_colorspace(),
				pixbuf_orig->get_has_alpha(),
				pixbuf_orig->get_bits_per_sample(),
				width, height);

	for (int x = 0; x < width; x++)
	  pixbuf_orig->copy_area(x, 0, 1, height,
				 pixbuf_tmp, width - 1 - x, 0);

	Glib::RefPtr<Gdk::Pixbuf> pixbuf_new
	  = Gdk::Pixbuf::create(pixbuf_orig->get_colorspace(),
				pixbuf_orig->get_has_alpha(),
				pixbuf_orig->get_bits_per_sample(),
				width, height);

	for (int y = 0; y < height; y++)
	  pixbuf_tmp->copy_area(0, y, width, 1,
				pixbuf_new, 0, height - 1 - y);

	pixbuf.push_back(pixbuf_new);
      } // DOWN
      { // LEFT
	Glib::RefPtr<Gdk::Pixbuf> pixbuf_new
	  = Gdk::Pixbuf::create(pixbuf_orig->get_colorspace(),
				pixbuf_orig->get_has_alpha(),
				pixbuf_orig->get_bits_per_sample(),
				height, width);

	for (int x = 0; x < width; x++)
	  for (int y = 0; y < height; y++)
	    pixbuf_orig->copy_area(x, y, 1, 1,
				   pixbuf_new, y, width - 1 - x);

	pixbuf.push_back(pixbuf_new);
      } // LEFT
      { // RIGHT
	Glib::RefPtr<Gdk::Pixbuf> pixbuf_tmp
	  = Gdk::Pixbuf::create(pixbuf_orig->get_colorspace(),
				pixbuf_orig->get_has_alpha(),
				pixbuf_orig->get_bits_per_sample(),
				height, width);

	for (int x = 0; x < width; x++)
	  pixbuf.back()->copy_area(0, x, height, 1,
				   pixbuf_tmp, 0, width - 1 - x);

	Glib::RefPtr<Gdk::Pixbuf> pixbuf_new
	  = Gdk::Pixbuf::create(pixbuf_orig->get_colorspace(),
				pixbuf_orig->get_has_alpha(),
				pixbuf_orig->get_bits_per_sample(),
				height, width);

	for (int y = 0; y < height; y++)
	  pixbuf_tmp->copy_area(y, 0, 1, width,
				pixbuf_new, height - 1 - y, 0);

	pixbuf.push_back(pixbuf_new);
      } // RIGHT

      return pixbuf;
  } // vector<Glib::RefPtr<Gdk::Pixbuf> > load_pixbuf_with_rotations(string const filename)
#endif // #ifdef OUTDATED

  /**
   **
   ** -> result
   **
   ** @param	pixbuf		the pixbuf that is to be rotated
   ** @param	rotation	the rotation
   **
   ** @return	the rotated pixbuf
   **
   ** @version	0.5.4
   **
   ** @author	Diether Knof
   **
   **/
  Glib::RefPtr<Gdk::Bitmap>
    bitmap(Glib::RefPtr<Gdk::Pixbuf> const pixbuf)
    {
      Glib::RefPtr<Gdk::Pixmap> pixmap;
      Glib::RefPtr<Gdk::Bitmap> bitmap;

      pixbuf->render_pixmap_and_mask(pixmap, bitmap,
				     ALPHA_THRESHOLD);

      return bitmap;
    } // Glib::RefPtr<Gdk::Bitmap> bitmap(Glib::RefPtr<Gdk::Pixbuf> const pixbuf)

  /**
   **
   ** toggles whether 'widget' is to be shown, depending on the state of
   ** 'toggle_button'
   **
   ** @param	widget		widget to toggle the view of
   ** @param	toggle_button	button with the state
   **
   ** @return	-
   **
   ** @version	0.6.5
   **
   ** @author	Diether Knof
   **
   **/
  void
    toggle_view(Gtk::Widget* const widget,
		Gtk::ToggleButton* const toggle_button)
    {
      if (toggle_button->get_active()
	  && toggle_button->is_visible())
	widget->show();
      else
	widget->hide();

      return ;
    } // void toggle_view(Gtk::Widget* const widget, Gtk::ToggleButton* const toggle_button)

  /**
   **
   ** sets the signal so that 'widget' is to be shown, depending on the state of
   ** 'toggle_button'
   **
   ** @param	widget		widget to toggle the view of
   ** @param	toggle_button	button with the state
   **
   ** @return	-
   **
   ** @version	0.6.5
   **
   ** @author	Diether Knof
   **
   **/
  void
    set_signal_toggle_view(Gtk::Widget* const widget,
			   Gtk::ToggleButton* const toggle_button)
    {
      toggle_button->signal_toggled().connect(sigc::bind<Gtk::Widget* const, Gtk::ToggleButton* const>(sigc::ptr_fun(&toggle_view), widget, toggle_button));

      toggle_button->signal_realize().connect(sigc::bind<Gtk::Widget* const, Gtk::ToggleButton* const>(sigc::ptr_fun(&toggle_view), widget, toggle_button));

      toggle_button->signal_show().connect(sigc::bind<Gtk::Widget* const, Gtk::ToggleButton* const>(sigc::ptr_fun(&toggle_view), widget, toggle_button));
      toggle_button->signal_hide().connect(sigc::bind<Gtk::Widget* const, Gtk::ToggleButton* const>(sigc::ptr_fun(&toggle_view), widget, toggle_button));

      toggle_button->signal_unmap().connect(sigc::bind<Gtk::Widget* const, Gtk::ToggleButton* const>(sigc::ptr_fun(&toggle_view), widget, toggle_button));

      return ;
    } // void set_signal_toggle_view(Gtk::Widget* const widget, Gtk::ToggleButton* const toggle_button)

} // namespace UI_GTKMM_NS

#endif // #ifdef USE_UI_GTKMM
