/**********************************************************************
 *
 *   FreeDoko a Doppelkopf-Game
 *    
 *   Copyright (C) 2001-2006  by Diether Knof and Borg Enders
 *
 *   This program is free software; you can redistribute it and/or 
 *   modify it under the terms of the GNU General Public Rules as 
 *   published by the Free Software Foundation; either version 2 of 
 *   the Rules, or (at your option) any later version.
 *
 *   This program is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *   GNU General Public Rules for more details. 
 *   You can find this license in the file 'gpl.txt'.
 *
 *   You should have received a copy of the GNU General Public Rules
 *   along with this program; if not, write to the Free Software
 *   Foundation, Inc., 59 Temple Place, Suite 330, Boston, 
 *   MA  02111-1307  USA
 *
 *  Contact:
 *    Diether Knof dknof@gmx.de
 *    Borg Enders  borg@borgsoft.de
 *
 **********************************************************************/

#include "constants.h"

#ifdef USE_UI_GTKMM

#include "sticky_dialog.h"
#include "../main_window.h"
#include "../ui.h"

#include <gdk/gdkkeysyms.h>

namespace Gtk {

  /**
   ** constructor
   **
   ** @param	title	the title of the window
   ** @param	modal	whether the window is modal
   **			(default: false)
   **
   ** @return	-
   ** 
   ** @author	Diether Knof
   **
   ** @version	0.7.0
   **/
  StickyDialog::StickyDialog(Glib::ustring const& title,
			     bool const modal) :
    Dialog(title, modal, true),
    x(INT_MAX),
    y(INT_MAX),
    main_window(NULL)
  {
    return ;
  }

  /**
   ** constructor
   **
   ** @param	title		the title of the window
   ** @param	main_window	the main window (transient)
   ** @param	modal		whether the window is modal
   **				(default: false)
   **
   ** @return	-
   ** 
   ** @author	Diether Knof
   **
   ** @version	0.7.0
   **/
  StickyDialog::StickyDialog(Glib::ustring const& title,
			     UI_GTKMM_NS::MainWindow& main_window,
			     bool const modal) :
    Dialog(title, main_window, modal, true),
    x(INT_MAX),
    y(INT_MAX),
    main_window(&main_window)
  {
    return ;
  }

  /**
   ** destructor
   **
   ** @param	-
   **
   ** @return	-
   ** 
   ** @author	Diether Knof
   **
   ** @version	0.7.0
   **
   **/
  StickyDialog::~StickyDialog()
  {
    return ;
  }

  /**
   ** event: the window is hidden
   ** remember the position of the window
   **
   ** @param	-
   **
   ** @return	-
   ** 
   ** @author	Diether Knof
   **
   ** @version	0.7.0
   **/
  void
    StickyDialog::on_hide()
    {
      this->get_position(this->x, this->y);
      this->Dialog::on_hide();
      return ;
    } // void on_hide()

  /**
   ** event: the window is shown
   ** move the window to the remembered position
   **
   ** @param	-
   **
   ** @return	-
   ** 
   ** @author	Diether Knof
   **
   ** @version	0.7.0
   **/
  void
    StickyDialog::on_show()
    {
      if (this->x != INT_MAX)
	this->move(this->x, this->y);
      this->Dialog::on_show();
      return ;
    } // void on_show()

  /**
   ** event: a key has been pressed
   **
   ** @param	key	pressed key
   **
   ** @return	whether the key was accepted
   ** 
   ** @author	Diether Knof
   **
   ** @version	0.7.0
   **/
  bool
    StickyDialog::on_key_press_event(GdkEventKey* key)
    {
      // key commands
      //   Escape: close the window

      if (key->state == 0) {
	switch (key->keyval) {
	case GDK_Escape:
	  this->hide();
	  return true;
	} // switch (key->keyval)
      } // if (key->state == 0)

      return (   this->Gtk::Dialog::on_key_press_event(key)
	      || (this->main_window
		  ? this->main_window->on_key_press_event(key)
		  : false) );
    } // bool StickyDialog::on_key_press_event(GdkEventKey* key)

} // namespace Gtk

#endif // #ifdef USE_UI_GTKMM
