; Script generated by the HM NIS Edit Script Wizard.

;---------------------
;Include Modern UI
!include "MUI.nsh"

;--------------------------------
;General

!define PRODUCT_NAME "FreeDoko"
!define PRODUCT_VERSION "$%VERSION%"
!define PRODUCT_AUTHORS "Borg Enders und Diether Knof"
!define PRODUCT_PUBLISHER "${PRODUCT_AUTHORS}"
!define PRODUCT_WEB_SITE "http://free-doko.sourceforge.net/"

;Name and file
Name "${PRODUCT_NAME} ${PRODUCT_VERSION}"
OutFile "${PRODUCT_NAME}_${PRODUCT_VERSION}.full.Setup.exe"

;Default installation folder
InstallDir "$PROGRAMFILES\${PRODUCT_NAME}"

;Get installation folder from registry if available
;InstallDirRegKey HKCU "Software\Modern UI Test" ""
!define PRODUCT_DIR_REGKEY "Software\Microsoft\Windows\CurrentVersion\App Paths\${PRODUCT_NAME}.exe"
!define PRODUCT_UNINST_KEY "Software\Microsoft\Windows\CurrentVersion\Uninstall\${PRODUCT_NAME}"
!define PRODUCT_UNINST_ROOT_KEY "HKLM"
InstallDirRegKey HKLM "${PRODUCT_DIR_REGKEY}" ""

;--------------------------------
;Pages

Page custom Uebersichtsseite
;!insertmacro MUI_PAGE_STARTMENU Application $ICONS_GROUP
; Instfiles page
!insertmacro MUI_PAGE_INSTFILES

;--------------------------------
;Interface Settings

!define MUI_ABORTWARNING

;--------------------------------
;Languages

!insertmacro MUI_LANGUAGE "English"
!insertmacro MUI_LANGUAGE "German"
!insertmacro MUI_LANGUAGE "French"

;--------------------------------
;Reserve Files

;These files should be inserted before other files in the data block
;Keep these lines before any File command
;Only for solid compression (by default, solid compression is enabled for BZIP2 and LZMA)
ReserveFile "FreeDoko.ini"
!insertmacro MUI_RESERVEFILE_INSTALLOPTIONS

;--------------------------------
;Variables

Var CREATE_DESKTOP_ICON
Var ICONS_GROUP

; load the language files
;LoadLanguageFile "${NSISDIR}\Contrib\Language files\English.nlf"
;LoadLanguageFile "${NSISDIR}\Contrib\Language files\German.nlf"


;!define LANG_ENGLISH 1033
;!define LANG_GERMAN  1031
;!define LANG_FRENCH  ???

; set the text
LangString LangDescription ${LANG_ENGLISH} \
    "FreeDoko is a free implementation of the card game 'Doppelkopf', programmed by Borg Enders and Diehter Knof.\r\nThe program is licensed under the GNU General Public License (http://www.gnu.org/licenses/gpl.html).\r\n\r\nThe internet page of FreeDoko is http://free-doko.sourceforge.net.\r\n\r\nSpecial thanks to the company 'Altenburg' which allows us till the end of 2006 to use their cardset in FreeDoko."
LangString LangInstallationDirectory ${LANG_ENGLISH} \
    "Installation directory:"
LangString LangProgramGroup ${LANG_ENGLISH} \
    "Program group:"
LangString LangCreateSymbolOnDesktop ${LANG_ENGLISH} \
    "Create symbol on the desktop"
LangString LangTitle ${LANG_ENGLISH} \
    "${PRODUCT_NAME} ${PRODUCT_VERSION} full installer"
LangString LangOverview ${LANG_ENGLISH} \
    "Overview"
LangString LangDeinstallation ${LANG_ENGLISH} \
  "Do you want de uninstall $(^Name) and all its components?"
LangString LangDeinstallationFinished ${LANG_ENGLISH} \
  "$(^Name) was uninstalled successfully"

LangString LangDescription ${LANG_FRENCH} \
    "FreeDoko is a free implementation of the card game 'Doppelkopf', programmed by Borg Enders and Diehter Knof.\r\nThe program is licensed under the GNU General Public License (http://www.gnu.org/licenses/gpl.html).\r\n\r\nThe internet page of FreeDoko is http://free-doko.sourceforge.net.\r\n\r\nSpecial thanks to the company 'Altenburg' which allows us till the end of 2006 to use their cardset in FreeDoko."
LangString LangInstallationDirectory ${LANG_FRENCH} \
    "Installation directory:"
LangString LangProgramGroup ${LANG_FRENCH} \
    "Program group:"
LangString LangCreateSymbolOnDesktop ${LANG_FRENCH} \
    "Create symbol on the desktop"
LangString LangTitle ${LANG_FRENCH} \
    "${PRODUCT_NAME} ${PRODUCT_VERSION} full installer"
LangString LangOverview ${LANG_FRENCH} \
    "Overview"
LangString LangDeinstallation ${LANG_FRENCH} \
  "Do you want de uninstall $(^Name) and all its components?"
LangString LangDeinstallationFinished ${LANG_FRENCH} \
  "$(^Name) was uninstalled successfully"

LangString LangDescription ${LANG_GERMAN} \
    "FreeDoko ist eine freie Implementierung des Kartenspiels 'Doppelkopf', programmiert von Borg Enders und Diether Knof.\r\nDas Programm steht unter der GNU General Public License (http://www.gnu.org/licenses/gpl.html), Benutzung auf eigene Verantwortung.\r\n\r\nDie Internetseite von FreeDoko lautet http://free-doko.sourceforge.net.\r\n\r\nBesonderen Dank gilt noch der Firma Altenburg, die uns bis Ende 2006 erlaubt, ihren Kartensatz in FreeDoko zu nutzen."
LangString LangInstallationDirectory ${LANG_GERMAN} \
    "Installationsverzeichnis:"
LangString LangProgramGroup ${LANG_GERMAN} \
    "Programmgruppe:"
LangString LangCreateSymbolOnDesktop ${LANG_GERMAN} \
    "Symbol auf dem Desktop erstellen"
LangString LangTitle ${LANG_GERMAN} \
    "${PRODUCT_NAME} ${PRODUCT_VERSION} Vollinstallation"
LangString LangOverview ${LANG_GERMAN} \
    "bersicht"
LangString LangDeinstallation ${LANG_GERMAN} \
  "Mchten Sie $(^Name) und alle seinen Komponenten deinstallieren?"
LangString LangDeinstallationFinished ${LANG_GERMAN} \
  "$(^Name) wurde erfolgreich deinstalliert."

;--------------------------------
;Installer Sections

Var WindowsLanguageNumber
Var WindowsLanguageNumberLastDigit
Function .onInit
  ;!insertmacro MUI_LANGDLL_DISPLAY

  ; set the language given by the registry
  ReadRegStr $WindowsLanguageNumber "HKCU" "Control Panel\International" "Locale"
  StrCpy $WindowsLanguageNumberLastDigit $WindowsLanguageNumber "" -1
  StrCpy $LANGUAGE ${LANG_ENGLISH}
  StrCmp $WindowsLanguageNumberLastDigit 9 0 +2 ; english
  StrCpy $LANGUAGE ${LANG_ENGLISH}
  StrCmp $WindowsLanguageNumberLastDigit 7 0 +2 ; german
  StrCpy $LANGUAGE ${LANG_GERMAN}
  StrCmp $WindowsLanguageNumberLastDigit A 0 +2 ; spanish
  StrCpy $LANGUAGE ${LANG_ENGLISH}
  StrCmp $WindowsLanguageNumberLastDigit C 0 +2 ; french
  StrCpy $LANGUAGE ${LANG_FRENCH}
FunctionEnd

Function Uebersichtsseite
  !insertmacro MUI_INSTALLOPTIONS_EXTRACT "FreeDoko.ini"

  ; set the text
  !insertmacro MUI_HEADER_TEXT $(LangTitle) $(LangOverview)
  !insertmacro MUI_INSTALLOPTIONS_WRITE "FreeDoko.ini" "Field 1" "State" \
    $(LangDescription)
  !insertmacro MUI_INSTALLOPTIONS_WRITE "FreeDoko.ini" "Field 2" "Text" \
    $(LangInstallationDirectory)
  !insertmacro MUI_INSTALLOPTIONS_WRITE "FreeDoko.ini" "Field 4" "Text" \
    $(LangProgramGroup)
  !insertmacro MUI_INSTALLOPTIONS_WRITE "FreeDoko.ini" "Field 6" "Text" \
    $(LangCreateSymbolOnDesktop)

  ; set the default values
  !insertmacro MUI_INSTALLOPTIONS_WRITE "FreeDoko.ini" "Field 3" "State" "$PROGRAMFILES\${PRODUCT_NAME}"
  !insertmacro MUI_INSTALLOPTIONS_WRITE "FreeDoko.ini" "Field 5" "State" ${PRODUCT_NAME}
  !insertmacro MUI_INSTALLOPTIONS_WRITE "FreeDoko.ini" "Field 6" "State" "1"

  ; show the window
  !insertmacro MUI_INSTALLOPTIONS_DISPLAY "FreeDoko.ini"
FunctionEnd

Section "Installation"
  ;Read the values from
  !insertmacro MUI_INSTALLOPTIONS_READ $CREATE_DESKTOP_ICON "FreeDoko.ini" "Field 6" "State"
  !insertmacro MUI_INSTALLOPTIONS_READ $ICONS_GROUP "FreeDoko.ini" "Field 5" "State"
  !insertmacro MUI_INSTALLOPTIONS_READ $INSTDIR "FreeDoko.ini" "Field 3" "State"


  SetOutPath "$INSTDIR"
  SetOverwrite try
  File /r "${PRODUCT_NAME}_${PRODUCT_VERSION}\*"

  ;Display a messagebox if check box was checked
  StrCmp $CREATE_DESKTOP_ICON "0" +2
  CreateShortCut "$DESKTOP\${PRODUCT_NAME}.lnk" "$INSTDIR\${PRODUCT_NAME}.bat" "" "$INSTDIR\${PRODUCT_NAME}.ico"

  StrCmp $ICONS_GROUP "" EndIconGroup
  CreateDirectory "$SMPROGRAMS\$ICONS_GROUP"
  CreateShortCut "$SMPROGRAMS\$ICONS_GROUP\${PRODUCT_NAME}.lnk" "$INSTDIR\${PRODUCT_NAME}.bat" "" "$INSTDIR\${PRODUCT_NAME}.ico"
  CreateShortCut "$SMPROGRAMS\$ICONS_GROUP\uninstall.lnk" "$INSTDIR\uninst.exe"
  ; german

  StrCmp $LANGUAGE ${LANG_ENGLISH} icon_group_english
  StrCmp $LANGUAGE ${LANG_GERMAN}  icon_group_german
  StrCmp $LANGUAGE ${LANG_FRENCH}  icon_group_french
  goto icon_group_english

icon_group_english: ; english
icon_group_french: ; french
  CreateDirectory "$SMPROGRAMS\$ICONS_GROUP\documentation"
  CreateShortCut "$SMPROGRAMS\$ICONS_GROUP\documentation\manual.lnk" "$INSTDIR\doc\manual\en\overview.html"
  CreateShortCut "$SMPROGRAMS\$ICONS_GROUP\documentation\introduction.lnk" "$INSTDIR\doc\manual\en\introduction.html"
  CreateShortCut "$SMPROGRAMS\$ICONS_GROUP\documentation\rules.lnk" "$INSTDIR\doc\manual\en\rules.html"
  goto icon_group_end

icon_group_german: ; german
  CreateDirectory "$SMPROGRAMS\$ICONS_GROUP\Dokumentation"
  CreateShortCut "$SMPROGRAMS\$ICONS_GROUP\Dokumentation\Handbuch.lnk" "$INSTDIR\doc\manual\de\overview.html"
  CreateShortCut "$SMPROGRAMS\$ICONS_GROUP\Dokumentation\Einfhrung.lnk" "$INSTDIR\doc\manual\de\introduction.html"
  CreateShortCut "$SMPROGRAMS\$ICONS_GROUP\Dokumentation\Regeln.lnk" "$INSTDIR\doc\manual\de\rules.html"
  goto icon_group_end

icon_group_end:
EndIconGroup:
SectionEnd

Section -Post
  WriteUninstaller "$INSTDIR\uninst.exe"
  WriteRegStr HKLM "${PRODUCT_DIR_REGKEY}" "" "$INSTDIR\${PRODUCT_NAME}.exe"
  WriteRegStr ${PRODUCT_UNINST_ROOT_KEY} "${PRODUCT_UNINST_KEY}" "DisplayName" "$(^Name)"
  WriteRegStr ${PRODUCT_UNINST_ROOT_KEY} "${PRODUCT_UNINST_KEY}" "UninstallString" "$INSTDIR\uninst.exe"
  WriteRegStr ${PRODUCT_UNINST_ROOT_KEY} "${PRODUCT_UNINST_KEY}" "DisplayIcon" "$INSTDIR\${PRODUCT_NAME}.exe"
  WriteRegStr ${PRODUCT_UNINST_ROOT_KEY} "${PRODUCT_UNINST_KEY}" "DisplayVersion" "${PRODUCT_VERSION}"
  WriteRegStr ${PRODUCT_UNINST_ROOT_KEY} "${PRODUCT_UNINST_KEY}" "URLInfoAbout" "${PRODUCT_WEB_SITE}"
  WriteRegStr ${PRODUCT_UNINST_ROOT_KEY} "${PRODUCT_UNINST_KEY}" "Publisher" "${PRODUCT_PUBLISHER}"
  WriteRegStr ${PRODUCT_UNINST_ROOT_KEY} "${PRODUCT_UNINST_KEY}" "InstDir" "$INSTDIR"
  WriteRegStr ${PRODUCT_UNINST_ROOT_KEY} "${PRODUCT_UNINST_KEY}" "IconsGroup" "$ICONS_GROUP"

  WriteRegStr HKLM "Software\${PRODUCT_NAME}" "Version" "${PRODUCT_VERSION}"
  WriteRegStr HKLM "Software\${PRODUCT_NAME}" "Directory" "$INSTDIR"
  WriteRegStr HKLM "Software\${PRODUCT_NAME}" "Help Directory" "$INSTDIR\doc\manual"
SectionEnd


Function un.onUninstSuccess
  HideWindow
  MessageBox MB_ICONINFORMATION|MB_OK $(LangDeinstallationFinished)
FunctionEnd

Function un.onInit
  ;!insertmacro MUI_UNGETLANGUAGE
  MessageBox MB_ICONQUESTION|MB_YESNO|MB_DEFBUTTON2 $(LangDeinstallation) IDYES +2
  Abort
FunctionEnd

Section Uninstall
  ;!insertmacro MUI_STARTMENU_GETFOLDER "Application" $ICONS_GROUP

  ReadRegStr $INSTDIR ${PRODUCT_UNINST_ROOT_KEY} "${PRODUCT_UNINST_KEY}" "InstDir"
  ReadRegStr $ICONS_GROUP ${PRODUCT_UNINST_ROOT_KEY} "${PRODUCT_UNINST_KEY}" "IconsGroup"

  RMDir /r "$INSTDIR"
  StrCmp $ICONS_GROUP "" +2
  RMDir /r "$SMPROGRAMS\$ICONS_GROUP"
  Delete "$DESKTOP\${PRODUCT_NAME}.lnk"

  DeleteRegKey ${PRODUCT_UNINST_ROOT_KEY} "${PRODUCT_UNINST_KEY}"
  DeleteRegKey HKLM "${PRODUCT_DIR_REGKEY}"
  DeleteRegKey HKLM "Software\${PRODUCT_NAME}"
  SetAutoClose true
SectionEnd
