/**********************************************************************
 *
 *   FreeDoko a Doppelkopf-Game
 *    
 *   Copyright (C) 2001-2006  by Diether Knof and Borg Enders
 *
 *   This program is free software; you can redistribute it and/or 
 *   modify it under the terms of the GNU General Public License as 
 *   published by the Free Software Foundation; either version 2 of 
 *   the License, or (at your option) any later version.
 *
 *   This program is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *   GNU General Public License for more details. 
 *   You can find this license in the file 'gpl.txt'.
 *
 *   You should have received a copy of the GNU General Public License
 *   along with this program; if not, write to the Free Software
 *   Foundation, Inc., 59 Temple Place, Suite 330, Boston, 
 *   MA  02111-1307  USA
 *
 *  Contact:
 *    Diether Knof dknof@gmx.de
 *    Borg Enders  borg@borgsoft.de
 *
 *********************************************************************/

#include "constants.h"
#include "card.h"

#include "../party/party.h"
#include "../party/rule.h"
#include "../game/game.h"

Card const Card::CLUB_QUEEN(Card::CLUB, Card::QUEEN);
Card const Card::CHARLIE(Card::CLUB, Card::JACK);
Card const Card::DOLLE(Card::HEART, Card::TEN);

/**
 **
 ** -> result
 **
 ** @param	gametype	the gametype
 **
 ** @return	true if card is trump in a game of type 'gametype'
 **
 ** @version	0.5.4
 **
 ** @author	Borg Enders
 ** @author	Diether Knof
 **
 **/
bool
Card::istrump(GameType const gametype) const
{
  if (this->isdolle(gametype))
    return true;

  switch (gametype) {
  case GAMETYPE::FIVE_NINES:
    if (this->value() == NINE)
      return true;
    break;
  case GAMETYPE::SIX_KINGS:
    if (this->value() == KING)
      return true;
    break;
  case GAMETYPE::NORMAL:
  case GAMETYPE::POVERTY:
  case GAMETYPE::FOX_HIGHEST_TRUMP:
  case GAMETYPE::GENSCHER:
  case GAMETYPE::MARRIAGE:
  case GAMETYPE::MARRIAGE_SOLO:
  case GAMETYPE::MARRIAGE_SILENT:
  case GAMETYPE::SOLO_DIAMOND:
    if (this->color() == DIAMOND)
      return true;
    if ((this->value() == JACK) || (this->value() == QUEEN))
      return true;
    break;
  case GAMETYPE::SOLO_JACK:
    if (this->value() == JACK)
      return true;
    break;
  case GAMETYPE::SOLO_QUEEN:
    if (this->value() == QUEEN)
      return true;
    break;
  case GAMETYPE::SOLO_KING:
    if (this->value() == KING)
      return true;
    break;
  case GAMETYPE::SOLO_QUEEN_JACK:
    if ((this->value() == JACK) || (this->value() == QUEEN))
      return true;
    break;
  case GAMETYPE::SOLO_KING_JACK:
    if ((this->value() == JACK) || (this->value() == KING))
      return true;
    break;
  case GAMETYPE::SOLO_KING_QUEEN:
    if ((this->value() == QUEEN) || (this->value() == KING))
      return true;
    break;
  case GAMETYPE::SOLO_KOEHLER:
    if ((this->value() == JACK) || (this->value() == QUEEN) || (this->value() == KING))
      return true;
    break;
  case GAMETYPE::SOLO_CLUB:
    if (this->color() == CLUB)
      return true;
    if ((this->value() == JACK)
	|| (this->value() == QUEEN))
      return true;
    break;
  case GAMETYPE::SOLO_HEART:
    if (this->color() == HEART)
      return true;
    if ((this->value() == JACK)
	|| (this->value() == QUEEN))
      return true;
    break;
  case GAMETYPE::SOLO_SPADE:
    if (this->color() == SPADE)
      return true;
    if ((this->value() == JACK)
	|| (this->value() == QUEEN))
      return true;
    break;
  case GAMETYPE::SOLO_MEATLESS:
    break;
  } // switch(gametype)

  return false;
} // bool Card::istrump(GameType const gametype) const

/**
 **
 ** -> result
 **
 ** @param	gametype	game type
 **
 ** @return	true if card is a dolle
 **
 ** @version	0.6.8
 **
 ** @author	Borg Enders
 ** @author	Diether Knof
 **
 ** @bug	not independent of the game
 **
 **/
bool
Card::isdolle(GameType const gametype) const
{
  if (!::party.rule()(Rule::DOLLEN))
    return false;

  if (*this != Card::DOLLE)
    return false;

  bool value = false;

  switch (gametype) {
  case GAMETYPE::NORMAL:
  case GAMETYPE::POVERTY:
  case GAMETYPE::GENSCHER:
  case GAMETYPE::MARRIAGE:
  case GAMETYPE::MARRIAGE_SOLO:
  case GAMETYPE::MARRIAGE_SILENT:
  case GAMETYPE::SOLO_CLUB:
  case GAMETYPE::SOLO_HEART:
  case GAMETYPE::SOLO_SPADE:
  case GAMETYPE::SOLO_DIAMOND:
    value = true;
    break;
  case GAMETYPE::SIX_KINGS:
  case GAMETYPE::FOX_HIGHEST_TRUMP:
  case GAMETYPE::SOLO_MEATLESS:
  case GAMETYPE::SOLO_JACK:
  case GAMETYPE::SOLO_QUEEN:
  case GAMETYPE::SOLO_KING:
  case GAMETYPE::SOLO_QUEEN_JACK:
  case GAMETYPE::SOLO_KING_JACK:
  case GAMETYPE::SOLO_KING_QUEEN:
  case GAMETYPE::SOLO_KOEHLER:
  case GAMETYPE::FIVE_NINES:
    value = false;
    break;
  } // switch (gametype)

  return value;
} // bool Card::isdolle(GameType gametype) const
