/**********************************************************************
 *
 *   FreeDoko a Doppelkopf-Game
 *    
 *   Copyright (C) 2001-2006  by Diether Knof and Borg Enders
 *
 *   This program is free software; you can redistribute it and/or 
 *   modify it under the terms of the GNU General Public License as 
 *   published by the Free Software Foundation; either version 2 of 
 *   the License, or (at your option) any later version.
 *
 *   This program is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *   GNU General Public License for more details. 
 *   You can find this license in the file 'gpl.txt'.
 *
 *   You should have received a copy of the GNU General Public License
 *   along with this program; if not, write to the Free Software
 *   Foundation, Inc., 59 Temple Place, Suite 330, Boston, 
 *   MA  02111-1307  USA
 *
 *  Contact:
 *    Diether Knof dknof@gmx.de
 *    Borg Enders  borg@borgsoft.de
 *
 **********************************************************************/

#ifndef CLASS_HAND_CARDS_HEADER
#define CLASS_HAND_CARDS_HEADER

#include "../basistypes.h"
#include "hand_card.h"
class Trick;
class Player;

/**
 ** Hand (of a player) with all cards (played and not played)
 **
 ** @author	Borg Enders
 ** @author	Diether Knof
 **/
class HandCards : public vector<HandCard> {
  public:
    HandCards(vector<HandCard> const& cards);
    HandCards(vector<Card> const& cards);
    HandCards(Hand const& hand, vector<Card> const& cards);
    HandCards(unsigned const n);
    HandCards(istream& istr);
    HandCards();
    HandCards(HandCards const&);
    HandCards& operator=(HandCards const&);
    ~HandCards();
    
    operator vector<Card>() const;

    // the number of cards
    unsigned cardsnumber() const;

    // the player the hand cards belong to 
    HandCard const& card(unsigned const i) const;

    // the player the hand cards belong to 
    Player const& player() const;

    // the highest card 
    HandCard const& highest_card() const;


    // remove 'cards'
    void remove(HandCards const& cards);


    // whether there is a trump card in the hand
    bool hastrump() const;
    // wheteher there exists a card with the given color
    bool existstcolor(Card::TColor const& tcolor) const;

    // the number of cards with the value
    unsigned numberof(Card::Value const& value) const;
    // the number of cards with the trump color
    unsigned numberof(Card::TColor const& tcolor) const;
    // the number of cards 'card'
    unsigned numberof(Card const& card) const;
    // the number of cards 'Card(tcolor, value)'
    unsigned numberof(Card::TColor const& tcolor,
		      Card::Value const& value) const;

    // the number of cards 'Card(color)' without counting trump
    unsigned numberof(Card::Color const& color, Game const& game) const;
    unsigned numberof(Card::Color const& color,
		      GameType const gametype,
		      bool const dollen) const;

    // the number of trumps
    unsigned numberoftrumps() const;
    // the number of trumps aces
    unsigned numberoftrumpaces() const;
    // the number of trumps nines
    unsigned numberoftrumpnines() const;
    // the number of trump kings
    unsigned numberoftrumpkings() const;
    // the number of nines
    unsigned numberofnines() const;
    // the number of kings
    unsigned numberofkings() const;
    // the number of club queens
    unsigned numberofclubqueens() const;


    // whether 'cards' is equal to 'this' (without order)
    bool equal(HandCards const& cards) const;

  private: // unused
}; // class HandCards : public vector<HandCard>

// write the cards in the output
ostream& operator<<(ostream& ostr, HandCards const& cards);

#endif // #ifndef CLASS_HAND_CARDS_HEADER
