/**********************************************************************
 *
 *   FreeDoko a Doppelkopf-Game
 *    
 *   Copyright (C) 2001-2006  by Diether Knof and Borg Enders
 *
 *   This program is free software; you can redistribute it and/or 
 *   modify it under the terms of the GNU General Public License as 
 *   published by the Free Software Foundation; either version 2 of 
 *   the License, or (at your option) any later version.
 *
 *   This program is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *   GNU General Public License for more details. 
 *   You can find this license in the file 'gpl.txt'.
 *
 *   You should have received a copy of the GNU General Public License
 *   along with this program; if not, write to the Free Software
 *   Foundation, Inc., 59 Temple Place, Suite 330, Boston, 
 *   MA  02111-1307  USA
 *
 *  Contact:
 *    Diether Knof dknof@gmx.de
 *    Borg Enders  borg@borgsoft.de
 *
 **********************************************************************/

#ifndef HEADER_CONSTANTS
#define HEADER_CONSTANTS

// using the microsoft visual C++ compiler
#ifdef _MSC_VER
#define MS_VISUAL_C
#define WINDOWS
#endif

// C++ include

#include <typeinfo>
#include <iostream>
#include <iomanip>
#include <fstream>
#include <sstream>
#include <algorithm>

// for temporary output
#define COUT cout

#include <vector>
#include <list>
#include <queue>
#include <map>
#include <set>
#include <string>

using namespace std;



#ifdef WINDOWS
#define USE_REGISTRY
#endif

#ifdef WINDOWS
#ifdef USE_REGISTRY
#include <windows.h>
#undef min
#undef max
#endif
#endif


#ifndef MS_VISUAL_C
#include <dirent.h>
#endif


#include "utils/version.h"


// Whether GTKMM can be used.
// When not defined, FreeDoko should compile and run without any GTKMM library
// this makro shall be defined through the compiler (in the makefile)
//#define GTKMM


// code, that is postphoned -- leave this macro undefined
#undef POSTPHONED

// code that is workaround -- leave this macro defined
#define WORKAROUND


extern DK::Utils::Version const version;
extern std::vector<DK::Utils::Version const*> all_versions;
#define CONTACT "freedoko@users.sourceforge.net"


// In the release-version there are some elements hidden
//#define RELEASE
//#define VERSION_DESCRIPTION "preversion"

#ifdef RELEASE
#define NO_CRITICAL_CHECKS
#endif


namespace FAST_NS {
  enum BIT {
    NONE	         = 0,
    PARTY_START          = 1,                         // automatical start party
    PLAYER               = PARTY_START          << 1, // change human players to ais
    RANDOM_AI            = PLAYER               << 1, // set the players to the random ai
    PAUSE                = RANDOM_AI            << 1, // skip pauses
    GAMEPLAY_INFORMATION = PAUSE                << 1, // skip gameplay information dialogs
    GAME_FINISHED        = GAMEPLAY_INFORMATION << 1, // skip game finished dialog
    SHOW_ALL_HANDS       = GAME_FINISHED        << 1  // show all hands
  }; // enum BIT
  extern int const ALL;
} // namespace FAST_NS
// All players are AI, there is no pause and no 'full trick'-window
extern int FAST_PLAY;

// mutate the rules after each game
extern bool const MUTATE_RULE;

// There is only output of the game seed
extern bool const SEED_OUT;
// the starting seed
extern unsigned const SEED_START;
// the starting player
extern unsigned const STARTPLAYER;

#ifdef USE_THREADS
extern unsigned THREADS;
#endif

#include "info.h"

// some utils (RAND(int), MARK(), expand_filename(string), Null_Str
#include "utils.h"


// whether an assertion shall create a segmentation fault (for a core dump)
// (define it in 'Makefile.local')
//#define ASSERTION_GENERATES_SEGFAULT

#ifdef RELEASE
// if DEBUG_NO_OUTPUT is defined, debugging information are not written
#define DEBUG_NO_OUTPUT
#endif

// whether to use debug informations
#define DEBUG

#ifndef DEBUG
// if DEBUG_NO is defined, the internal checks are skipped
// this speeds up the program up to factor 4
#define DEBUG_NO
#endif

// debugging utils
#include "debug.h"

// creates a segmentation fault
#define SEGFAULT cerr << "Created segmentation fault:\n" \
  << __FILE__ << " # " << __LINE__ << endl; \
(*reinterpret_cast<int*>(NULL) = 0)


// output of the name
#define WRITE_NAME(Type) \
  inline ostream& operator<<(ostream& ostr, Type const& t) \
{ return (ostr << ::name(t)); }
#define WRITE_NAME2(Namespace, Type) \
  inline ostream& operator<<(ostream& ostr, Namespace::Type const& t) \
{ return (ostr << ::name(t)); }


#endif // #ifndef HEADER_CONSTANTS
