/**********************************************************************
 *
 *   FreeDoko a Doppelkopf-Game
 *    
 *   Copyright (C) 2001-2006  by Diether Knof and Borg Enders
 *
 *   This program is free software; you can redistribute it and/or 
 *   modify it under the terms of the GNU General Public License as 
 *   published by the Free Software Foundation; either version 2 of 
 *   the License, or (at your option) any later version.
 *
 *   This program is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *   GNU General Public License for more details. 
 *   You can find this license in the file 'gpl.txt'.
 *
 *   You should have received a copy of the GNU General Public License
 *   along with this program; if not, write to the Free Software
 *   Foundation, Inc., 59 Temple Place, Suite 330, Boston, 
 *   MA  02111-1307  USA
 *
 *  Contact:
 *    Diether Knof dknof@gmx.de
 *    Borg Enders  borg@borgsoft.de
 *
 **********************************************************************/

#ifdef USE_UI_GTKMM

#ifndef GTKMM_GAMEINFO_DIALOG_HEADER
#define GTKMM_GAMEINFO_DIALOG_HEADER

#include "base.h"

class Player;

#include "widgets/sticky_dialog.h"
namespace Gtk {
  class StockButton;
}; // namespace Gtk

namespace UI_GTKMM_NS {
  class Table;

  /**
   **
   ** @brief	base class for information dialogs
   **
   ** @author	Diether Knof
   **
   **/
  class GameinfoDialog : public Base, public Gtk::StickyDialog {
    public:
      GameinfoDialog(Table* const table);

      virtual ~GameinfoDialog();

      Table& table();
      virtual void show_information(bool const show,
				    bool const close_automatically,
				    unsigned const close_delay);
      virtual void show_information();

      virtual void close();

      bool on_timeout();

      virtual void name_changed(Player const& player);
      
    protected:
      virtual void init();

      virtual bool on_key_press_event(GdkEventKey* key);

    public:
      virtual void mouse_click_on_table();

    protected:
      // close button
      Gtk::StockButton* close_button;
      // variable for the timeout signal
      sigc::connection timeout_connection;

    private: // unused
      GameinfoDialog();
      GameinfoDialog(GameinfoDialog const&);
      GameinfoDialog& operator=(GameinfoDialog const&);
  }; // class GameinfoDialog : public Base, public Gtk::StickyDialog

} // namespace UI_GTKMM_NS

#endif // #ifdef GTKMM_GAMEINFO_DIALOG_HEADER

#endif // #ifdef USE_UI_GTKMM
