/**********************************************************************
 *
 *   FreeDoko a Doppelkopf-Game
 *    
 *   Copyright (C) 2001-2006  by Diether Knof and Borg Enders
 *
 *   This program is free software; you can redistribute it and/or 
 *   modify it under the terms of the GNU General Public License as 
 *   published by the Free Software Foundation; either version 2 of 
 *   the License, or (at your option) any later version.
 *
 *   This program is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *   GNU General Public License for more details. 
 *   You can find this license in the file 'gpl.txt'.
 *
 *   You should have received a copy of the GNU General Public License
 *   along with this program; if not, write to the Free Software
 *   Foundation, Inc., 59 Temple Place, Suite 330, Boston, 
 *   MA  02111-1307  USA
 *
 *  Contact:
 *    Diether Knof dknof@gmx.de
 *    Borg Enders  borg@borgsoft.de
 *
 **********************************************************************/

#ifdef USE_UI_GTKMM

#ifndef GTKMM_GENSCHER_INFO_HEADER
#define GTKMM_GENSCHER_INFO_HEADER

#include "gameinfo_dialog.h"

class Player;

namespace Gtk {
  class Image;
  class Label;
}; // namespace Gtk

namespace UI_GTKMM_NS {
  class Table;

  /**
   **
   ** @brief	genscher information dialog
   **
   ** @author	Diether Knof
   **
   **/
  class GenscherInfo : public GameinfoDialog {
    public:
      GenscherInfo(Table* const table);

      ~GenscherInfo();

      void show_information(Player const& genscher, Player const& partner);

      void name_changed(Player const& player);
      
    private:
      void init();

    private:
      Gtk::Image* icon;
      Gtk::Label* text;

      Player const* genscher;
      Player const* partner;

    private: // unused
      GenscherInfo();
      GenscherInfo(GenscherInfo const&);
      GenscherInfo& operator=(GenscherInfo const&);
  }; // class GenscherInfo : public GameinfoDialog

} // namespace UI_GTKMM_NS

#endif // #ifdef GTKMM_GENSCHER_INFO_HEADER

#endif // #ifdef USE_UI_GTKMM
