/**********************************************************************
 *
 *   FreeDoko a Doppelkopf-Game
 *    
 *   Copyright (C) 2001-2006  by Diether Knof and Borg Enders
 *
 *   This program is free software; you can redistribute it and/or 
 *   modify it under the terms of the GNU General Public License as 
 *   published by the Free Software Foundation; either version 2 of 
 *   the License, or (at your option) any later version.
 *
 *   This program is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *   GNU General Public License for more details. 
 *   You can find this license in the file 'gpl.txt'.
 *
 *   You should have received a copy of the GNU General Public License
 *   along with this program; if not, write to the Free Software
 *   Foundation, Inc., 59 Temple Place, Suite 330, Boston, 
 *   MA  02111-1307  USA
 *
 *  Contact:
 *    Diether Knof dknof@gmx.de
 *    Borg Enders  borg@borgsoft.de
 *
 *********************************************************************/

#include "constants.h"

#ifdef USE_UI_GTKMM

#include "swines_info.h"
#include "table.h"
#include "ui.h"
#include "translations.h"
#include "icons.h"
#include "main_window.h"
#include "menu.h"

#include "../../party/rule.h"
#include "../../game/game.h"
#include "../../player/player.h"
#include "../../misc/setting.h"

#include <gtkmm/box.h>
#include <gtkmm/image.h>
#include <gtkmm/label.h>

namespace UI_GTKMM_NS {

  /**
   **
   ** Constructor
   **
   ** @param	table	the table
   **
   ** @return	-
   ** 
   ** @author	Diether Knof
   **
   ** @version	0.6.6
   **
   **/
  SwinesInfo::SwinesInfo(Table* const table) :
    GameinfoDialog(table),
  icon(NULL),
  text(NULL),
  hyperswines_announce_button(NULL),
  player(NULL),
  swines(true)
  {
    return ;
  } // SwinesInfo::SwinesInfo(Table* const table)

  /**
   **
   ** Destruktor
   **
   ** @param	-
   **
   ** @return	-
   ** 
   ** @author	Diether Knof
   **
   ** @version	0.6.1
   **
   **/
  SwinesInfo::~SwinesInfo()
  {
    return ;
  } // SwinesInfo::~SwinesInfo()

  /**
   **
   ** init the dialog
   **
   ** @param	-
   **
   ** @return	-
   ** 
   ** @author	Diether Knof
   **
   ** @version	0.6.1
   **
   **/
  void
    SwinesInfo::init()
    {
      this->GameinfoDialog::init();
      this->ui->translations->add(*this, ::translation("~swines"));

      this->icon = this->ui->icons->new_managed_image();
      this->text = Gtk::manage(new Gtk::Label("Player has swines."));
      this->ui->translations->add(*(this->text),
				    ::translation("%splayer% has swines.",
						 this->player->name()
						));

      Gtk::VBox* vbox = Gtk::manage(new Gtk::VBox(false, 2 ex));
      vbox->set_border_width(2 ex);

      vbox->add(*this->icon);
      vbox->add(*this->text);

      this->get_vbox()->add(*vbox);

      this->hyperswines_announce_button
	= Gtk::manage(new Gtk::Button("announce hyperswines"));
      this->ui->translations->add(*this->hyperswines_announce_button,
				    ::translation("hyperswines"));
      this->get_action_area()->pack_start(*this->hyperswines_announce_button);
      this->get_action_area()->reorder_child(*this->hyperswines_announce_button,
					     0);

      this->hyperswines_announce_button->signal_clicked().connect(sigc::bind<unsigned const>(sigc::mem_fun(*this->ui->main_window->menu, &Menu::hyperswines_announcement_event), UINT_MAX));
      this->hyperswines_announce_button->signal_clicked().connect(sigc::mem_fun(*this, &GameinfoDialog::close));

      this->show_all_children();

      return ;
    } // void SwinesInfo::init()

  /**
   **
   ** show the window
   **
   ** @param	player	the player who has swines
   **
   ** @return	-
   ** 
   ** @author	Diether Knof
   **
   ** @version	0.6.6
   **
   **/
  void
    SwinesInfo::show_swines_information(Player const& player)
    {
      this->player = &player;
      if (!this->is_realized())
	this->realize();

      this->swines = true;

      // If a color solo is played the human player has got to have a chance
      // to announce hyperswines.
      this->hyperswines_announce_button->hide();
      if (player.game().rule()(Rule::HYPERSWINES)) {
	for (vector<Player*>::const_iterator p = player.game().players_begin();
	     p != player.game().players_end();
	     p++) {
	  if (((*p)->type() == Player::HUMAN)
	      && player.game().hyperswines_announcement_valid(**p)) {
	    this->hyperswines_announce_button->show();
	    break;
	  } // if (human player)
	} // for (p \in player.game().players)
      } // if (player.game().rule()(Rule::HYPERSWINES_ANNOUNCEMENT_BEGIN))

      this->ui->translations->change(*this, ::translation("~swines"));
      this->ui->icons->change_managed_swines(this->icon,
					     this->player->game().trumpcolor());
      this->name_changed(player);

      this->GameinfoDialog::show_information(::setting(Setting::SHOW_SWINES_WINDOW),
					     ::setting(Setting::CLOSE_SWINES_WINDOW_AUTOMATICALLY),
					     ::setting(Setting::SWINES_WINDOW_CLOSE_DELAY));

      this->ui->icons->change_managed(this->icon, Icons::NONE);
      this->player = NULL;

      return ;
    } // void SwinesInfo::show_swines_information(Player const& player)

  /**
   **
   ** show the window
   **
   ** @param	player	the player who has hyperswines
   **
   ** @return	-
   ** 
   ** @author	Diether Knof
   **
   ** @version	0.6.6
   **
   **/
  void
    SwinesInfo::show_hyperswines_information(Player const& player)
    {
      this->player = &player;
      if (!this->is_realized())
	this->realize();

      this->swines = false;
      this->hyperswines_announce_button->hide();

      this->ui->translations->change(*this, ::translation("~hyperswines"));
      this->ui->icons->change_managed_hyperswines(this->icon,
					     this->player->game().trumpcolor());
      this->name_changed(player);

      this->GameinfoDialog::show_information(::setting(Setting::SHOW_SWINES_WINDOW),
					     ::setting(Setting::CLOSE_SWINES_WINDOW_AUTOMATICALLY),
					     ::setting(Setting::SWINES_WINDOW_CLOSE_DELAY));

      this->ui->icons->change_managed(this->icon, Icons::NONE);
      this->player = NULL;

      return ;
    } // void SwinesInfo::show_hyperswines_information(Player const& player)

  /**
   **
   ** the name of 'player' has changed
   **
   ** @param	player	the player whose name has changed
   **
   ** @return	-
   ** 
   ** @author	Diether Knof
   **
   ** @version	0.6.1
   **
   **/
  void
    SwinesInfo::name_changed(Player const& player)
    {
      if (player.is_same(*(this->player))) {
	if (this->swines) {
	  if (player.game().rule()(Rule::SWINE_ONLY_SECOND))
	    this->ui->translations->change(*this->text,
					   ::translation("%splayer% has a swine.",
							this->player->name()
						       ));
	  else
	    this->ui->translations->change(*this->text,
					   ::translation("%splayer% has swines.",
							this->player->name()
						       ));
	} else {
	  this->ui->translations->change(*this->text,
					 ::translation("%splayer% has hyperswines.",
						      this->player->name()
						     ));
	}
      }

      return ;
    } // void SwinesInfo::name_changed(Player const& player)

} // namespace UI_GTKMM_NS

#endif // #ifdef USE_UI_GTKMM
