//////////////////////////////////////////////////////////////////////////////
//
//   Copyright (C) 2002  by Diether Knof
//
//   This program is free software; you can redistribute it and/or 
//   modify it under the terms of the GNU General Public License as 
//   published by the Free Software Foundation; either version 2 of 
//   the License, or (at your option) any later version.
//
//   This program is distributed in the hope that it will be useful,
//   but WITHOUT ANY WARRANTY; without even the implied warranty of
//   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//   GNU General Public License for more details. 
//   You can find this license in the file 'gpl.txt'.
//
//   You should have received a copy of the GNU General Public License
//   along with this program; if not, write to the Free Software
//   Foundation, Inc., 59 Temple Place, Suite 330, Boston, 
//   MA  02111-1307  USA
//
//  Contact:
//    Diether Knof dknof@gmx.de
//
//////////////////////////////////////////////////////////////////////////////

#ifndef DK_UTILS_DATE_HEADER
#define DK_UTILS_DATE_HEADER

#include <iosfwd>
#include <functional>
#include <string>

namespace DK {
  namespace Utils {
    class Date;

    Date* new_Date(std::istream& istr);
    Date* new_Date(std::string const& s);

    class Date {
      public:
	Date();
	Date(int const year, unsigned const month, unsigned const day);
	Date(Date const&);
	~Date();

	std::ostream& write(std::ostream& ostr) const;

	operator std::string const() const;

	int const year;
	unsigned const month;
	unsigned const day;

      private:
	Date& operator=(Date const& date);
    }; // class Version

    bool operator==(Date const& d1, Date const& d2);
    bool operator<(Date const& d1, Date const& d2);

    std::ostream& operator<<(std::ostream& ostr, Date const& date);
  } // namespace Utils
} // namespace DK

#endif // #ifndef DK_UTILS_DATE_HEADER
