(use gauche.net)
(use gauche.selector)
(use gauche.listener)

(define (echo-server port)
  (let ((selector (make <selector>))
        (servers  (make-server-sockets #f port :reuse-addr? #t)))

    (define (echo client input output)
      (let ((str (read-block 4096 input)))
        (if (eof-object? str)
            (begin (selector-delete! selector input #f #f)
                   (socket-close client))
            (begin (display str output)
                   (flush output)))))

    (for-each
     (lambda (server)

       (define (accept-handler sock flag)
	 (let* ((client (socket-accept server))
		(output (socket-output-port client)))
	   (selector-add! selector
			  (socket-input-port client :buffered? #f)
			  (lambda (input flag)
			    (echo client input output))
			  '(r))))

       (selector-add! selector
		      (socket-fd server)
		      accept-handler
		      '(r)))
     servers)

    ;; Add listener to the current input/output port
    (let* ((listener (make <listener>))
           (handler  (listener-read-handler listener)))

      (set! (port-buffering (current-input-port)) :none)
      (selector-add! selector
                     (current-input-port)
                     (lambda _ (handler))
                     '(r))
      ;; the first prompt
      (listener-show-prompt listener))

    (do () (#f) (selector-select selector))))

(define (main args)
  (print "echo server starting on port 3131")
  (echo-server 3131)
  0)
