#include "Bobcat.h"

/*
    Glasteroids, a asteroids type game.
    Copyright (C) 1999 Matt Cohen

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; version 2 of the License.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/


void BCworld::InitializeCollisionTest ( void )
{
    int i, j;

    for ( i = 0; i < MAX_TOTAL_OBJECTS; i++ )
	for ( j = 0; j < MAX_TOTAL_OBJECTS; j++ )
	    colliding[i][j] = 0;
}


int BCworld::CollisionTest ( BCobject *A, BCobject *B,
			     float *vx, float *vy )
{
    double distance, collision_distance;
    float normX, normY, mag;
    int retval = 0;
    
    // First make sure both objects are active and not the same
    if ( !A->active || !B->active || A == B)
	return ( 0 );
    
    distance = sqrt ( ( A->xLoc - B->xLoc ) *
                      ( A->xLoc - B->xLoc ) +
		      ( A->yLoc - B->yLoc ) *
                      ( A->yLoc - B->yLoc )   );
    
    collision_distance = A->radius + B->radius;
    
    if ( distance <= collision_distance )
    {
        if ( !colliding[A->listNumber][B->listNumber] && 
	     !colliding[B->listNumber][A->listNumber]     )
	{	

	    normX = A->xLoc - B->xLoc;
	    normY = A->yLoc - B->yLoc;
	    
	    mag = sqrt ( normX*normX + normY*normY );
	    
	    if ( mag > EPSILON )  
	    {	  
		*vx = normX/mag;    
		*vy = normY/mag;    
		
		colliding[A->listNumber][B->listNumber] = 1;
		colliding[B->listNumber][A->listNumber] = 1;

		retval = 1;
	    }
	}
    }
    else
    {
	colliding[A->listNumber][B->listNumber] = 0;
	colliding[B->listNumber][A->listNumber] = 0;
    }
    
    return ( retval );
}


void BCworld::ProcessObjectCollision ( BCobject *A, BCobject *B, 
				       float normalX, float normalY )
{
    float j;
    float normalXtemp, normalYtemp;
    float oneOverMb, oneOverMa;
    float vTotalX, vTotalY;
    float dp1, dp2;
    
    //////////////////// Compute j /////////////////////////
    
    oneOverMa = A->oneOverM;
    oneOverMb = B->oneOverM;
    
    // Total direction vector
    vTotalX = A->xSpeed - B->xSpeed;
    vTotalY = A->ySpeed - B->ySpeed;
    
    // Scalar mulitply by -(1+e)
    vTotalX *= (-1.0 - elasticity);
    vTotalY *= (-1.0 - elasticity);
    
    // Dot product of above vector and normal vector
    dp1 = vTotalX * normalX + vTotalY * normalY;
    
    // Compute normal*(1/Ma+1/Mb)
    normalXtemp = normalX * ( oneOverMa + oneOverMb );
    normalYtemp = normalY * ( oneOverMa + oneOverMb );
    
    // Dot product of normal and normal*(1/Ma+1/Mb)
    dp2 = normalX * normalXtemp + normalY * normalYtemp;
    
    // divide to get j
    j = dp1/dp2;
    
    ///////////////// Compute A's direction ////////////////
    
    A->xSpeed += (j * oneOverMa * normalX);
    A->ySpeed += (j * oneOverMa * normalY);
    
    ///////////////// Compute B's direction ////////////////
    
    B->xSpeed -= (j * oneOverMb * normalX);
    B->ySpeed -= (j * oneOverMb * normalY);
}
