#include "BCenemy.h"

/*
    Glasteroids, a asteroids type game.
    Copyright (C) 1999 Matt Cohen

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; version 2 of the License.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/



BCenemy::BCenemy ( float w, float h, float r, float m )
{
    Ship = new BCship ( w, h, r, m );
    Ship->SetPowerCoreColor ( 1.0, 0.0, 0.0 );
    Ship->SetBulletColor ( 1.0, 0.0, 0.0 );
 
    ResetShip ( );
}

BCenemy::~BCenemy ( void )
{
    delete Ship;
}


void BCenemy::UpdateEnemyShipExplosion ( double time )
{
    Ship->UpdateShipExplosion ( time );
}


void BCenemy::DrawEnemyShipExploding ( void )
{
    Ship->DrawShipExploding ( );
}

int BCenemy::UpdateShipLocation ( double time )
{
    // Update the rings (spinning)
    Ship->ringsRotY += Ship->ringsRotYspeed * time;
    if ( Ship->ringsRotY > 360.0 )
        Ship->ringsRotY -= 360.0;
    else if (  Ship->ringsRotY < 0.0 )
        Ship->ringsRotY += 360.0;
    
    // Move the ship along the x axis
    Ship->objData.xLoc += Ship->objData.xSpeed * time;
    Ship->objData.yLoc += Ship->objData.ySpeed * time;
    
    // make sure ship stays in bounds
    if ( Ship->objData.xLoc > Ship->worldWidth/2.0 + 10.0 )
    {
        Ship->objData.active = 0;
        Ship->fire = 0;
        return ( 0 );
    }
    else if ( Ship->objData.xLoc < -Ship->worldWidth/2.0 - 10.0 )
    {
        Ship->objData.active = 0;
        Ship->fire = 0;
        return ( 0 );
    }

    if ( Ship->objData.yLoc > Ship->worldHeight/2.0 + 10.0 )
    {
        Ship->objData.active = 0;
        Ship->fire = 0;
        return ( 0 );
    }
    else if ( Ship->objData.yLoc < -Ship->worldHeight/2.0 - 10.0 )
    {
        Ship->objData.active = 0;
        Ship->fire = 0;
        return ( 0 );
    }
    
    return ( 1 );
}


void BCenemy::StartShip ( void )
{
    Ship->objData.active = 1;
    Ship->life = 100.0;
    Ship->fire = 1;
    Ship->startExplosion = 1;
    Ship->numActiveBullets = 0;

    Ship->objData.xLoc
        = (float)(rand()%(int)Ship->worldWidth) - Ship->worldWidth/2.0;
    Ship->objData.yLoc = Ship->worldHeight/2.0 + 5.0;

    Ship->objData.ySpeed = (float)(-(rand()%5 + 5));

    if ( Ship->objData.xLoc > 0.0 )
        Ship->objData.xSpeed = (float)(-rand()%10);
    else
        Ship->objData.xSpeed = (float)(rand()%10);
}


void BCenemy::ResetShip ( void )
{
    int i;

    StartShip ( );

    Ship->fire = 0;
    Ship->objData.active = 0;

    for ( i = 0; i < Ship->numBullets; i++ )
        Ship->Bullet[i].active = 0;

    elapsedTime = 0.0;
    nextShipTime = (double)(rand()%100)/25.0 + 4.0;
}


int BCenemy::GetStatus ( void )
{
    return ( Ship->objData.active );
}


int BCenemy::UpdateEnemyShip ( BCship *ship, double time )
{
    static float x, y;
    static int retval;

    if ( !Ship->objData.active ) 
    {
        // Start the timer
        elapsedTime += time;

        if ( elapsedTime > nextShipTime )
        {
            StartShip ( );
            elapsedTime = 0.0;

            // Ships come between 5 and 10 seconds
            nextShipTime = (double)(rand()%100)/25.0 + 4.0;
        }

        Ship->UpdateBullets ( time );

        retval = 0;
    }
    else
    {
        retval = UpdateShipLocation ( time );

        Ship->UpdateBullets ( time );
   
        x = Ship->objData.xLoc - ship->objData.xLoc;
        y = Ship->objData.yLoc - ship->objData.yLoc;
    
        Ship->ringsRotZ = CalculateAngle ( x, y ) + 90.0;
    }

    return ( retval );
}


int BCenemy::DrawEnemyShip ( void )
{
    static int retval;

    //if ( Ship->objData.active )
    retval = Ship->DrawShip ( );
    //else
    //	retval = 0;

    Ship->DrawBullets ( );

    return ( retval );
}


float BCenemy::CalculateAngle ( float x, float y )
{
    static double precise_angle;
    static double scale = 180.0/M_PI;
    static float angle;

    if ( fabs ( x ) < EPSILON )
    {
        /*********************************************/
        /*  on y axis                                */
        /*********************************************/
        if ( y < 0.0 )
            angle = 270.0;
        else
            angle = 90.0;   
    }
    else if ( fabs ( y ) < EPSILON )
    {
        /*********************************************/
        /*  on x axis                                */
        /*********************************************/
        if ( x < 0.0 )
            angle = 180.0;
        else
            angle = 0.0;
    }
    else if ( ( x > 0.0 ) && ( y > 0.0 ) )
    {
        /*********************************************/
        /*  First Quadrant                           */ 
        /*********************************************/
        precise_angle = atan2((double)y,(double)x);

        angle = (float)((precise_angle)*scale);
    }
    else if ( ( x < 0.0 ) && ( y > 0.0 ) )
    {
        /*********************************************/
        /*  Second Quadrant                          */
        /*********************************************/
        precise_angle = atan2((double)-x,(double)y);
    
        angle = (float)((precise_angle)*scale);
        angle += 90.0;
    }
    else if ( ( x < 0.0 ) && ( y < 0.0 ) )
    {
        /*********************************************/
        /*  Third Quadrant                           */
        /*********************************************/
        precise_angle = atan2((double)-y,(double)-x);      
    
        angle = (float)((precise_angle)*scale);
        angle += 180.0;
    }
    else if ( ( x > 0.0 ) && ( y < 0.0 ) )
    {
        /*********************************************/
        /*  Fourth Quadrant                          */
        /*********************************************/
        precise_angle = atan2((double)x,(double)-y);
    
        angle = (float)((precise_angle)*scale);
        angle += 270.0;
    }

    return ( angle );
}


