#ifndef BC_ENEMY_H
#define BC_ENEMY_H

/*
    Glasteroids, a asteroids type game.
    Copyright (C) 1999 Matt Cohen

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; version 2 of the License.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/


#include "BCincludes.h"
#include "BCship.h"


class BCenemy
{
  public:
    BCenemy ( float, float, float, float );
    ~BCenemy ( void );

    int UpdateEnemyShip ( BCship *, double );
    int DrawEnemyShip ( void );
    void StartShip ( void );
    void UpdateEnemyShipExplosion ( double );
    void DrawEnemyShipExploding ( void );
    void ResetShip ( );

    int BCenemy::GetStatus ( void );

    BCship *Ship;

  private:

    int UpdateShipLocation ( double );
    float CalculateAngle ( float x, float y );
 
    double elapsedTime;
    double nextShipTime;

};



#endif // BC_ENEMY_H
