#ifndef BC_INCLUDES_H
#define BC_INCLUDES_H


/*
    Glasteroids, a asteroids type game.
    Copyright (C) 1999 Matt Cohen

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; version 2 of the License.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/



#include <GL/glut.h>
#include <stdarg.h>
#include <stdlib.h>
#include <stdio.h>
#include <iostream.h>
#include <string.h>
#include <time.h>
#include <math.h>

#define EPSILON 0.0001
#define MAX_TOTAL_OBJECTS 1024

// Some <math.h> files do not define M_PI 
#ifndef M_PI
#define M_PI 3.14159265358979323846
#endif //M_PI

#define REGULAR_BULLET 0
#define EXPLODING_BULLET 1
#define SHIP_BASELINE -30.0

enum BcObjectArgs
{
    BcNULL,
    BcSIZE,
    BcSCALE,
    BcCOLOR,
    BcTEAPOT,
    BcSPHERE,
    BcCUBE,
    BcCONE,
    BcTORUS
};


enum BcGameState
{
    BcSTARTUP,
    BcGAME_MENU,
    BcGAME_IN_PROGRESS,
    BcGAME_PAUSED,
    BcGAME_DEAD_SHIP,
    BcGAME_OVER,
    BcEXITING_GAME
};


enum BcAxis
{
    BcAXIS_X,
    BcAXIS_Y,
    BcAXIS_Z
};


enum BcMenuItem
{
    BcMENU_MAIN,
    BcMENU_NEW,
    BcMENU_RESUME,
    BcMENU_HIGH_SCORES,
    BcMENU_DIRECTIONS,
    BcMENU_SETUP,
    BcMENU_QUIT,
    BcMENU_GAME_OVER,

    BcMENU_UP,
    BcMENU_DOWN
};


#endif //BC_INCLUDES_H
