#include "BCmenu.h"

/*
    Glasteroids, a asteroids type game.
    Copyright (C) 1999 Matt Cohen

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; version 2 of the License.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/


BCmenu::BCmenu ( TexFont *f )
{
    font = f;
    BuildMainMenu ( );

    InitializeHighScores ( );
    ReadHighScoresFromFile ( );

    currentMenu = BcMENU_MAIN;
    currentItem = BcMENU_NEW;

    strcpy ( playerName, "" );
    nameLength = 0;
    playerScore = 0;
}

BCmenu::~BCmenu ( void )
{
	
}


void BCmenu::BuildMainMenu ( void )
{
    strcpy ( newGame.text, "Begin New Game" );
    newGame.active = 1;

    strcpy ( resumeGame.text, " Resume Game" );
    resumeGame.active = 0;

    strcpy ( highScores.text, "  High Scores" );
    highScores.active = 0;

    strcpy ( directions.text, "   Directions" );
    directions.active = 0;

    strcpy ( setup.text, "     Setup" );
    setup.active = 0;

    strcpy ( quitGame.text, "      Quit" );
    quitGame.active = 0;
}


void BCmenu::DrawMenu ( void )
{
    glDisable ( GL_LIGHTING );

    switch ( currentMenu )
    {
	case BcMENU_MAIN:
            DrawMainMenu ( );
            break;
		
	case BcMENU_HIGH_SCORES:
            DrawHighScoresMenu ( );
            break;

	case BcMENU_DIRECTIONS:
            DrawDirections ( );
            break;

	case BcMENU_GAME_OVER:
            DisplayGameOverScreen ( );
            break;

	default:
            break;
    }

    glEnable ( GL_LIGHTING );
}


void BCmenu::DrawMainMenu ( void )
{
    glEnable ( GL_TEXTURE_2D );

    // Draw "New Game"
    glPushMatrix();

    if ( newGame.active )
        glColor3f(1.0, 0.0, 0.0);
    else
        glColor3f(1.0, 1.0, 0.0);

    glTranslatef ( -21.0, 15.0, 20.0 );
    glScalef( 0.15, 0.15, 0.15);
    txfRenderFancyString(font, newGame.text, (int) strlen(newGame.text));
	
    glPopMatrix();

    // Draw "Resume Game"
    glPushMatrix();

    if ( resumeGame.active )
        glColor3f(1.0, 0.0, 0.0);
    else
        glColor3f(1.0, 1.0, 0.0);

    glTranslatef ( -21.0, 7.5, 20.0 );
    glScalef( 0.15, 0.15, 0.15);
    txfRenderFancyString(font, resumeGame.text, (int) strlen(resumeGame.text));
	
    glPopMatrix();

    // Draw "High Score"
    glPushMatrix();

    if ( highScores.active )
        glColor3f(1.0, 0.0, 0.0);
    else
        glColor3f(1.0, 1.0, 0.0);

    glTranslatef ( -21.0, 0.0, 20.0 );
    glScalef( 0.15, 0.15, 0.15);
    txfRenderFancyString(font, highScores.text, (int) strlen(highScores.text));
	
    glPopMatrix();

    // Draw "Directions"
    glPushMatrix();

    if ( directions.active )
        glColor3f(1.0, 0.0, 0.0);
    else
        glColor3f(1.0, 1.0, 0.0);

    glTranslatef ( -21.0, -7.5, 20.0 );
    glScalef( 0.15, 0.15, 0.15);
    txfRenderFancyString(font, directions.text, (int) strlen(directions.text));
	
    glPopMatrix();

    // Draw "Setup"
    /*glPushMatrix();

      if ( setup.active )
      glColor3f(1.0, 0.0, 0.0);
      else
      glColor3f(1.0, 1.0, 0.0);

      glTranslatef ( -20.0, -10.0, 20.0 );
      glScalef( 0.15, 0.15, 0.15);
      txfRenderFancyString(font, setup.text, (int) strlen(setup.text));
	
      glPopMatrix();*/

    // Draw "Quit Game"
    glPushMatrix();

    if ( quitGame.active )
        glColor3f(1.0, 0.0, 0.0);
    else
        glColor3f(1.0, 1.0, 0.0);

    glTranslatef ( -21.0, -15.0, 20.0 );
    glScalef( 0.15, 0.15, 0.15);
    txfRenderFancyString(font, quitGame.text, (int) strlen(quitGame.text));
	
    glPopMatrix();

    glDisable ( GL_TEXTURE_2D );
}


void BCmenu::DrawHighScoresMenu ( void )
{
    int i, j, count, pad;
    char scoreString[128];
    char *temp;

    glColor3f(1.0, 1.0, 0.0);

    glEnable ( GL_TEXTURE_2D );

    for ( i = 0; i < MAX_HIGH_SCORES; i++ )
    {
        sprintf ( scoreString, "%d.     ", i+1 );

        if ( i+1 >= 10 )
            pad = 3;
        else
            pad = 4;

        count = 0;
        while ( Player[i].name[count] != '\0' )
        {
            scoreString[count+pad] = Player[i].name[count];
            count ++;
        }

        for ( j = count+pad; j < 25; j++ )
        {
            scoreString[j] = '.';
        }

        temp = &scoreString[25];

        sprintf ( temp, "%d", Player[i].score );

        // Draw "Quit Game"
        glPushMatrix();

        if ( quitGame.active )
            glColor3f(1.0, 0.0, 0.0);
        else
            glColor3f(1.0, 1.0, 0.0);

        glTranslatef ( -40.0, 20.0-(float)i*5.0, 20.0 );
        glScalef( 0.15, 0.15, 0.15);
        txfRenderFancyString(font, scoreString, (int) strlen(scoreString));
	
        glPopMatrix();
    }

    glDisable ( GL_TEXTURE_2D );
}


void BCmenu::DrawDirections ( void )
{
    static char arrowKeys[]   = "Arrow keys ... Move Ship";
    static char cannonKeys[]  = "< > .................. Move Cannon";
    static char spaceKey[]    = "Space Bar ...... Fire";
    static char shieldKey[]   = "X...................... Shield";
    static char destructKey[] = "D...................... Self destruct";
    static char functionKeys[]= "F1.......................show options";
    static char optionKeys[]  =  "F2....Texturing   F3....Shading";
    static char objective[]   = "  Object: Do Not Blow Up!";

    glEnable ( GL_TEXTURE_2D );

    glColor3f(1.0, 1.0, 0.0);

    // Draw "arrow keys"
    glPushMatrix();

    glTranslatef ( -40.0, 10.0, 20.0 );
    glScalef( 0.15, 0.15, 0.15);
    txfRenderFancyString(font, arrowKeys, (int) strlen(arrowKeys));
	
    glPopMatrix();

    // Draw "cannon keys"
    glPushMatrix();

    glTranslatef ( -40.0, 5.0, 20.0 );
    glScalef( 0.15, 0.15, 0.15);
    txfRenderFancyString(font, cannonKeys, (int) strlen(cannonKeys));
	
    glPopMatrix();

    // Draw "Space = fire"
    glPushMatrix();

    glTranslatef ( -40.0, 0.0, 20.0 );
    glScalef( 0.15, 0.15, 0.15);
    txfRenderFancyString(font, spaceKey, (int) strlen(spaceKey));
	
    glPopMatrix();

    // Draw "Shields"
    glPushMatrix();

    glTranslatef ( -40.0, -5.0, 20.0 );
    glScalef( 0.15, 0.15, 0.15);
    txfRenderFancyString(font, shieldKey, (int) strlen(shieldKey));
	
    glPopMatrix();

    // Draw "Self Destruct"
    glPushMatrix();

    glTranslatef ( -40.0, -10.0, 20.0 );
    glScalef( 0.15, 0.15, 0.15);
    txfRenderFancyString(font, destructKey, (int) strlen(destructKey));
	
    glPopMatrix();


    // Draw "Object"
    glPushMatrix();

    glTranslatef ( -40.0, -15.0, 20.0 );
    glScalef( 0.15, 0.15, 0.15);
    txfRenderFancyString(font, functionKeys, (int) strlen(functionKeys));
	
    glPopMatrix();

    // Draw "Object"
    glPushMatrix();

    glTranslatef ( -40.0, -20.0, 20.0 );
    glScalef( 0.15, 0.15, 0.15);
    txfRenderFancyString(font, optionKeys, (int) strlen(optionKeys));
	
    glPopMatrix();


    // Draw "Object"
    glPushMatrix();

    glTranslatef ( -40.0, -30.0, 20.0 );
    glScalef( 0.15, 0.15, 0.15);
    txfRenderFancyString(font, objective, (int) strlen(objective));
	
    glPopMatrix();

    glDisable ( GL_TEXTURE_2D );
}


void BCmenu::UpdateMenu ( int direction )
{
    switch ( currentMenu )
    {
	case BcMENU_MAIN:
        {
            switch ( direction )
            {
                case BcMENU_UP:

                    if ( currentItem == BcMENU_NEW )
                    {
                        currentItem = BcMENU_QUIT;
                        newGame.active = 0;
                        quitGame.active = 1;
                    }
                    else if ( currentItem == BcMENU_RESUME )
                    {
                        currentItem = BcMENU_NEW;
                        resumeGame.active = 0;
                        newGame.active = 1;
                    }
                    else if ( currentItem == BcMENU_HIGH_SCORES )
                    {
                        currentItem = BcMENU_RESUME;
                        highScores.active = 0;
                        resumeGame.active = 1;
                    }
                    else if ( currentItem == BcMENU_DIRECTIONS )
                    {
                        currentItem = BcMENU_HIGH_SCORES;
                        directions.active = 0;
                        highScores.active = 1;
                    }
                    /*else if ( currentItem == BcMENU_SETUP )
                      {
                      currentItem = BcMENU_DIRECTIONS;
                      setup.active = 0;
                      directions.active = 1;
                      }*/
                    else if ( currentItem == BcMENU_QUIT )
                    {
                        currentItem = BcMENU_DIRECTIONS;
                        quitGame.active = 0;
                        directions.active = 1;
                    }
	
                    break;

                case BcMENU_DOWN:

                    if ( currentItem == BcMENU_NEW )
                    {
                        currentItem = BcMENU_RESUME;
                        newGame.active = 0;
                        resumeGame.active = 1;
                    }
                    else if ( currentItem == BcMENU_RESUME )
                    {
                        currentItem = BcMENU_HIGH_SCORES;
                        resumeGame.active = 0;
                        highScores.active = 1;
                    }
                    else if ( currentItem == BcMENU_HIGH_SCORES )
                    {
                        currentItem = BcMENU_DIRECTIONS;
                        highScores.active = 0;
                        directions.active = 1;
                    }
                    else if ( currentItem == BcMENU_DIRECTIONS )
                    {
                        currentItem = BcMENU_QUIT;
                        directions.active = 0;
                        quitGame.active = 1;
                    }
                    /*else if ( currentItem == BcMENU_SETUP )
                      {
                      currentItem = BcMENU_QUIT;
                      setup.active = 0;
                      quitGame.active = 1;
                      }*/
                    else if ( currentItem == BcMENU_QUIT )
                    {
                        currentItem = BcMENU_NEW;
                        quitGame.active = 0;
                        newGame.active = 1;
                    }

                    break;

                default:
                    break;
            }

            break;
        }

	default:
            break;
    }
}			


void BCmenu::InitializeHighScores ( void )
{
    int i;

    for ( i = 0; i < MAX_HIGH_SCORES; i++ )
    {
        strcpy ( Player[i].name, "(EMPTY)" );
        Player[i].score = 0;
    }
}


void BCmenu::ReadHighScoresFromFile ( void )
{
    FILE *infile;
    char buffer[256];
    int i;

    if ( ! ( infile = fopen ( HIGH_SCORE_FILE, "r" ) ) )
    {
        cout << "Couldn't open high score file.\n";
        return;
    }

    for ( i = 0; i < MAX_HIGH_SCORES; i++ )
    {
        if ( ! ( fgets ( buffer, 256, infile ) ) )
            break;

        sscanf ( buffer, "%s%d", Player[i].name, &Player[i].score );
    }

    fclose ( infile );
}


void BCmenu::WriteHighScoresToFile ( void )
{
    FILE *outfile;
    char buffer[256];
    int i;

    if ( ! ( outfile = fopen ( HIGH_SCORE_FILE, "w" ) ) )
    {
        cout << "Couldn't open high score file.\n";
        return;
    }

    for ( i = 0; i < MAX_HIGH_SCORES; i++ )
    {
        sprintf ( buffer, "%s %d\n", Player[i].name, Player[i].score );
        fputs ( buffer, outfile );
    }

    fclose ( outfile );
}


int BCmenu::GetCurrentMenu ( void )
{
    return ( currentMenu );
}


int BCmenu::GetCurrentItem ( void )
{
    return ( currentItem );
}


void BCmenu::SetCurrentMenu ( int val )
{
    currentMenu = val;
}


void BCmenu::SetCurrentItem ( int val )
{
    currentItem = val;

    if ( currentMenu == BcMENU_MAIN )
    {
        newGame.active = 0;
        resumeGame.active = 0;
        highScores.active = 0;
        directions.active = 0;
        setup.active = 0;
        quitGame.active = 0;

        switch ( val )
        {
            case BcMENU_NEW:
                newGame.active = 1;
                break;
            case BcMENU_RESUME:
                resumeGame.active = 1;
                break;
            case BcMENU_HIGH_SCORES:
                highScores.active = 1;
                break;
            case BcMENU_DIRECTIONS:
                directions.active =	1;
                break;
            case BcMENU_SETUP:
                setup.active = 1;
                break;
            case BcMENU_QUIT:
                quitGame.active = 1;
                break;
            default:
                newGame.active = 1;
                break;
        }
    }
}


void BCmenu::DeterminePlayersRank ( int score )
{
    static int i;
	
    rank = 100;

    for ( i = MAX_HIGH_SCORES - 1; i >= 0; i-- )
    {
        if ( score >= Player[i].score )
        {
            playerScore = score;
            rank = i;
        }
    }

    if ( rank < 10 )
    {
        for ( i = MAX_HIGH_SCORES - 1; i > rank; i-- ) 
        {
            strcpy ( Player[i].name, Player[i-1].name );
            Player[i].score = Player[i-1].score;
        }
    }
}


void BCmenu::DisplayGameOverScreen ( void )
{
    static char overString[] = "Game Over";
    static char congrats[] = "Congratulations!  You reached a high score.";
    static char enterName[] = "Enter Name: ";
    static char nameString[64];

    glEnable ( GL_TEXTURE_2D );

    glColor3f(1.0, 1.0, 0.0);

    glPushMatrix();

    glTranslatef ( -18.0, 10.0, 20.0 );
    glScalef( 0.15, 0.15, 0.15);
    txfRenderFancyString(font, overString, (int) strlen(overString));
	
    glPopMatrix();

    if ( rank < 10 )
    {
        glPushMatrix();
	
        glTranslatef ( -45.0, 0.0, 20.0 );
        glScalef( 0.1, 0.1, 0.1);
        txfRenderFancyString(font, congrats, (int) strlen(congrats));
	
        glPopMatrix();

        strcpy ( nameString, enterName );
        strcat ( nameString, playerName );

        glPushMatrix();

        glTranslatef ( -35.0, -10.0, 20.0 );
        glScalef( 0.15, 0.15, 0.15);
        txfRenderFancyString(font, nameString, (int) strlen(nameString));
	
        glPopMatrix();
    }

    glDisable ( GL_TEXTURE_2D );
}


int BCmenu::AddCharToPlayersName ( int key )
{	
    if ( rank >= 10 )
    {
        if ( key == 13 || key == 27 )
            return ( 2 );
        else
            return ( 0 );
    }

    if ( key == 13 )      // Return
    {
        if ( nameLength > 0 )
            strcpy ( Player[rank].name, playerName );
        else 
            strcpy ( Player[rank].name, "(EMPTY)" );

        Player[rank].score = playerScore;

        strcpy ( playerName, "" );
        nameLength = 0;
        playerScore = 0;

        return ( 1 );
    }
    else if ( key == 8 )  // Backspace
    { 
        if ( nameLength > 0 )
        {
            nameLength --;
            playerName[nameLength] = '\0';
        }
    }
    else if ( ( key >= 'a' && key <= 'z' ) || 
              ( key >= 'A' && key <= 'Z' )    )
    {
        if ( nameLength < MAX_NAME_LENGTH )
        {
            playerName[nameLength] = key;
            nameLength ++;
            playerName[nameLength] = '\0';
        }
    }
    // else invalid key

    return ( 0 );
}
