#ifndef BC_MENU_H
#define BC_MENU_H

/*
    Glasteroids, a asteroids type game.
    Copyright (C) 1999 Matt Cohen

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; version 2 of the License.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/


#include "BCincludes.h"
#include "TexFont.h"

#define HIGH_SCORE_FILE "scores.txt"
#define MAX_HIGH_SCORES 10
#define MAX_NAME_LENGTH 10

typedef struct _BCsubMenu
{
    char text[64];
    int active;
} BCsubMenu;

typedef struct _BCplayer
{
    char name[64];
    int score;
} BCplayer;


class BCmenu
{

  public:
    BCmenu ( TexFont * );
    ~BCmenu ( void );

    void BuildMainMenu ( void );
    void DrawMenu ( void );
    void UpdateMenu ( int );

    int GetCurrentItem ( void );
    int GetCurrentMenu ( void );

    void SetCurrentItem ( int );
    void SetCurrentMenu ( int );

    void WriteHighScoresToFile ( void );

    int AddCharToPlayersName ( int );
    void DeterminePlayersRank ( int );


    int nameLength;
    char playerName[64];
    int rank;
    int playerScore;

  private:

    void DrawHighScoresMenu ( void );
    void DrawMainMenu ( void );
    void DisplayGameOverScreen ( void );
    void DrawDirections ( void );

    void InitializeHighScores ( void );
    void ReadHighScoresFromFile ( void );


    BCsubMenu newGame;
    BCsubMenu resumeGame;
    BCsubMenu highScores;
    BCsubMenu directions;
    BCsubMenu setup;
    BCsubMenu quitGame;

    int currentItem;
    int currentMenu;

    BCplayer Player[MAX_HIGH_SCORES];

    TexFont *font;
};

#endif //BC_MENU_H
