#ifndef BC_OBJECT_H
#define BC_OBJECT_H


/*
    Glasteroids, a asteroids type game.
    Copyright (C) 1999 Matt Cohen

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; version 2 of the License.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/



#include "BCincludes.h"
#include "MarchingCubes.h"

#define MAX_PARTICLES 100

typedef struct _BCparticle
{
    float x, y, vx, vy;
} BCparticle;

typedef struct _BCparticleSystem
{
    int active;

    BCparticle particle[MAX_PARTICLES];
    float color;
    float life;
    
} BCparticleSystem;

class BCobject
{

  public:

    BCobject ( void );
    ~BCobject ( void );

    void CreateIsosurface ( unsigned char *, MarchingCubes *, int, int, int, ... );
    void CreateGeometric ( enum BcObjectArgs, ... );

    void SetRotation ( int, enum BcAxis, float );
    void RotateObject ( int, ... );

    void SetTranslation ( int, enum BcAxis, float );
    void TranslateObject ( int, float, float, float );

    int active;
    int type;
    GLuint listNumber;

    float radius;
 
    int translate;
    float xLoc;
    float yLoc;
    float zLoc;

    float xLocMax, xLocMin;
    float yLocMax, yLocMin;
    float zLocMax, zLocMin;

    float xSpeed;
    float ySpeed;
    float zSpeed;

    int rotate;
    float xRot;
    float yRot;
    float zRot;

    float xRotSpeed;
    float yRotSpeed;
    float zRotSpeed;

    float mass;
    float oneOverM;

    int color;
    float colorRed;
    float colorGreen;
    float colorBlue;

  private:

    void BuildObject ( unsigned char *, 
		       int, int, int,
		       float, float, float, int,
		       float, float, float );

    int GetCubePolygons ( unsigned char *, Cell_Triangle_t *, 
			  int *, int, int, int, int, int, int );

    MarchingCubes *cube;
};

#endif // BC_OBJECT_H
