#ifndef BC_SHIP_H
#define BC_SHIP_H


/*
    Glasteroids, a asteroids type game.
    Copyright (C) 1999 Matt Cohen

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; version 2 of the License.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/



#include "BCobject.h"

#define MAX_BULLETS 10
#define RING_SPEED 200.0
#define BULLET_MASS 200.0
#define BULLET_SPEED 30.0
#define BULLET_RADIUS 0.75
#define BULLET_RELOAD_TIME 0.3
#define MAX_BULLET_PARTICLE_SYSTEMS 50
#define BULLET_EXPLOSION_LENGTH 3.0


class BCship
{

  public:
	
    BCship ( float = 100.0, float = 100.0, float = 5.0, 
	     float = 50.0 );
    ~BCship ( void );

    int  UpdateShip          ( float );   
    int  DrawShip            ( void );
    void DrawBullets         ( void );
    void UpdateBullets       ( float );
    void DrawLifeBars        ( void );
    void DrawShipExploding   ( void );
    void UpdateShipExplosion ( float );
    void ExplodeBullet       ( int );
    void ResetShip           ( void );
    void SetPowerCoreColor   ( float, float, float );
    void SetBulletColor      ( float, float, float );
    void UpdateShieldBar     ( double );
    void UpdateShield        ( int );

    BCobject objData;
    BCobject part[5];
    
    float hullRotXspeed;
    float hullRotYspeed;
    float hullRotZspeed;
    
    float ringsRotXspeed;
    float ringsRotYspeed;
    float ringsRotZspeed;

    float ringsRotX;
    float ringsRotY;
    float ringsRotZ;	

    float worldWidth;
    float worldHeight;
    
    int triggerRight;
    int triggerLeft;

    int joyLeft;
    int joyRight;
    int joyDown;
    int joyUp;

    int keyLeft;
    int keyRight;
    int keyDown;
    int keyUp;

    int right;
    int left;
    int up;
    int down;

    float life;
    float shieldLife;
    int startExplosion;
    int exploding;
    int numShipParts;
    int shieldUp;

    float baseLine;

    /* Bullet stuff */
    BCobject Bullet[MAX_BULLETS];
    BCparticleSystem ParticleSystem[MAX_BULLET_PARTICLE_SYSTEMS];
    int numParticleSystems;
    int numBullets;
    int numActiveBullets;
    int fire;
    int fireButton;
    float bulletSpeed;
    float bulletRadius;
    float bulletMass;

  private:
    
    void BuildBullets      ( void );
    void ActivateNewBullet ( void );
    void UpdateBulletExplosions ( double );
    void DrawBulletExplosions ( void );
    int ActiveParticleSystem ( void );

    void DrawShipShield ( void );

    void BuildShipHull     ( void );
    void BuildShipRings    ( void );
    void BuildShipShield   ( void );
    void BuildShipParts    ( void );
    void BuildPowerCore    ( void );

    GLuint hull;
    GLuint powerCore;
    GLuint rings;
    GLuint shield;

    GLfloat glow_emission[4];
    GLfloat bullet_color[3];

    int shieldButtonPressed;

    float bulletReloadTime;
    
    float cannonX;
    float cannonY;
    
    float xBulletMax;
    float xBulletMin;
    float yBulletMax;
    float yBulletMin;
    
    float hullRotX;
    float hullRotY;
    float hullRotZ;
};


#endif //BC_SHIP_H
