#ifndef BOBCAT_H
#define BOBCAT_H


/*
    Glasteroids, a asteroids type game.
    Copyright (C) 1999 Matt Cohen

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; version 2 of the License.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/



#include <stdio.h>
#include "BCincludes.h"
#include "GlutFunctions.h"
#include "BCobject.h"
#include "BCship.h"
#include "BCenemy.h"
#include "BCmenu.h"
#include "TexFont.h"

#define NUM_LARGE_ASTEROIDS 2
#define MAX_NUM_ACTIVE_ASTEROIDS 15
#define TEXTURE_SIZE 64

#define SMALL_ASTEROID 0
#define MEDIUM_ASTEROID 1
#define LARGE_ASTEROID 2
#define ALL_ASTEROIDS 3
#define ASTEROID_DUST_LENGTH 4.0
#define MAX_ASTEROID_DUST_SYSTEMS 50
#define NUM_STARS 100

typedef void ( *BCengineCB ) ( void * );

typedef struct _BCstar
{
    float x, y, vy;
    
} BCstar;

class BCworld
{
    
  public:
    
    BCworld ( void );
    ~BCworld ( void );
    
    void InitWorld ( int, char **, char *, int, int, float );
    void BeginWorld ( void );
    
    void AddDirectionalLight ( float x, float y, float z );
    
    void AddShip ( void );
    void Restart ( void );

    void InitializeCollisionTest ( void );
    int CollisionTest ( BCobject *, BCobject *, float *, float *);
    void CheckAsteroidsForCollisions ( void );
    void CheckShipForCollisionWithAsteroids ( void );
    void CheckBulletsForCollisions ( void );
    void CheckShipPartsForCollisions ( void );
    
    void ProcessObjectCollision ( BCobject *, BCobject *, float, float );
    
    void AddEngineFunction (void(*func)(void *));

    void DrawNormal ( void );
    void DrawGameMenu ( void );
    void DrawGameOver ( void );

    void BuildAsteroids ( void );
    void DrawAsteroids ( void );
    void UpdateAsteroids ( double );
    int ActivateNewAsteroid ( int ); 
    void DrawData ( double );
    void DrawScore ( void );
    void UpdateScore ( int );

    void MenuItemSelected ( void );
    
    int numAsteroids;
    int numLargeAsteroids;
    int numMediumAsteroids;
    int numSmallAsteroids;

    int numActiveAsteroids;
    int numActiveLargeAsteroids;
    int numActiveMediumAsteroids;
    int numActiveSmallAsteroids;

    BCobject **Asteroid;
    BCobject *LargeAsteroid;
    BCobject *MediumAsteroid;
    BCobject *SmallAsteroid;

    enum BcGameState State;
    
    int screenSizeX, screenSizeY;
    float worldWidth, worldHeight;
    
    float asteroidXmax, asteroidXmin;
    float asteroidYmax, asteroidYmin;

    int showData;
    int texturing;
    int smoothShading;
    
    BCship *Ship;
    BCenemy *Enemy;
    BCmenu *Menu;
    
    BCengineCB UserEngine;

    TexFont *font;

    int Score;
    
  private:

    void CheckEnemyBulletsForCollisions ( void );
    void CheckEnemyShipForCollisionWithBullets ( void );
    void CheckEnemyShipForCollisionWithAsteroids ( void );
    void CheckBothShipsForCollision ( void );
    void CheckEnemyShipPartsForCollisions ( void );
    void LoadSplashScreen ( char * );
    void DrawSplashScreen ( double );
    
    void BreakAsteroid ( int, int );
    void DrawTestSquare ( void );
    int ActivateAsteroidDust ( void );
    void UpdateAsteroidDust ( double );
    void DrawAsteroidDust ( void );

    void InitializeStars ( void );
    void UpdateStars ( double );
    void DrawStars ( void );

    void InitOpenGL ( void );

    void InitTextures ( void );
    void Build2dTexture ( void );
    void Build3dTexture ( void );
    
    void UpdateShipBullets ( );
    void UpdateBulletObjects ( void );
    void MakeRandomSurface ( unsigned char *data,
			     int x, int y, int z, int pad );
    
    void InitializeObject ( int );
    double GetCurrentFrameTime ( void );    

    int shipNumber;
    int *bulletNumber;
    
    unsigned char colliding[MAX_TOTAL_OBJECTS][MAX_TOTAL_OBJECTS];
    
    unsigned char *texture;
    unsigned char *splashTexture;
    unsigned char texture_2d[TEXTURE_SIZE][TEXTURE_SIZE];

    BCparticleSystem Dust[MAX_ASTEROID_DUST_SYSTEMS];
    int numActiveDust;

    BCstar Star[NUM_STARS];

    GLuint asteroid_texture;
    GLuint text_texture;
    GLuint splashScreen_texture;
    
    float elasticity;

    MarchingCubes mcubes;
};

BCworld * BCgetWorld ( void );

#endif //BOBCAT_H

