#include <stdlib.h>
#include <time.h>
#include "Bobcat.h"

/*
    Glasteroids, a asteroids type game.
    Copyright (C) 1999 Matt Cohen

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; version 2 of the License.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/



void engine ( void *w )
{
    BCworld *world = ( BCworld * ) w;
    
    switch ( world->State )
    {
	case BcSTARTUP:

            world->State = BcGAME_MENU;
	    break;
	    
	case BcGAME_PAUSED:

            world->State = BcGAME_MENU;
            world->Menu->SetCurrentItem ( BcMENU_RESUME );
	    break;
	    
	case BcGAME_MENU:

            world->DrawGameMenu ( );
            break;

	case BcGAME_IN_PROGRESS:

	    world->DrawNormal ( );
	    break;
	    
	case BcGAME_OVER:

            world->DrawGameOver ( );
            break;
	    
	case BcGAME_DEAD_SHIP:

            world->Menu->DeterminePlayersRank ( world->Score );
            world->State = BcGAME_OVER;
	    break;

	case BcEXITING_GAME:
            world->Menu->WriteHighScoresToFile ( );
            exit ( 0 );
            break;

	default:
	    break;
    }
}


int main ( int argc, char *argv[] )
{
    BCworld *world;
    
    world = BCgetWorld ( );

    world->InitWorld ( argc, argv,"Glasteroids", 640, 480, 100 );

    world->AddEngineFunction ( engine );
    
    world->BuildAsteroids ( );

    world->BeginWorld ( );

    return ( 0 );   // Successful termination
}

