////////////////////////////////////////////////////////////
#include "Bobcat.h"

/*
    Glasteroids, a asteroids type game.
    Copyright (C) 1999 Matt Cohen

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; version 2 of the License.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/


extern BCworld internalWorld;

void InternalIdle ( void )
{
    glutPostRedisplay ( );
}


void InternalDisplay ( void )
{
    internalWorld.UserEngine ( (void *)&internalWorld );
}


void InternalReshape ( int w, int h)
{
    float x, y;
    
    y = internalWorld.worldHeight/2.0;
    x = internalWorld.worldWidth/2.0;
    
    glViewport (0, 0, (GLsizei) w, (GLsizei) h);
    glMatrixMode ( GL_PROJECTION );
    glLoadIdentity ( );
    glOrtho ( -x, x, -y, y, 50.0, 125.0 ); 
    glMatrixMode ( GL_MODELVIEW );
    glLoadIdentity ( );
    gluLookAt (0.0, 0.0, 75.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0);
}


void InternalKeyboard ( unsigned char key, int x, int y )
{
    static int val;

    if ( internalWorld.State == BcGAME_MENU )
    {
        switch ( key )
        {
            case 13:
                internalWorld.MenuItemSelected ( );
                break;
            case 27:
                if ( internalWorld.Menu->GetCurrentMenu() == BcMENU_MAIN )
                {
                    if ( internalWorld.Ship->life > 0.0 )
                        internalWorld.State = BcGAME_IN_PROGRESS;
                }
                else
                {
                    internalWorld.Menu->SetCurrentMenu ( BcMENU_MAIN );
                    internalWorld.Menu->SetCurrentItem ( BcMENU_NEW );
                }
                break;
            default:
                break;
        }
    }
    else if ( internalWorld.State == BcGAME_OVER )
    {
        val = internalWorld.Menu->AddCharToPlayersName ( key );

        if ( val == 1 )
        {
            internalWorld.State = BcGAME_MENU;
            internalWorld.Menu->SetCurrentMenu ( BcMENU_HIGH_SCORES );
        }
        else if ( val == 2 )
        {
            internalWorld.State = BcGAME_MENU;
            internalWorld.Menu->SetCurrentMenu ( BcMENU_MAIN );
        }
    }
    else
    {
        switch ( key ) 
        {
            case 'x':
            case 'X':
                internalWorld.Ship->UpdateShield ( 1 );
                break;
	    
            case 'd':
            case 'D':
                internalWorld.Ship->life = 0.0;
                break;

            case 27:	
                internalWorld.State = BcGAME_PAUSED;
                break;
	    
            case '.':
            case '>':
                internalWorld.Ship->ringsRotZspeed = -200.0;
                internalWorld.Ship->triggerRight = 1;
                break;
	    
            case ',':
            case '<':
                internalWorld.Ship->ringsRotZspeed = 200.0;
                internalWorld.Ship->triggerRight = 1;
                break;
	    
            case ' ':
                internalWorld.Ship->fire = 1;
                break;
	    
            default:
                break;
        }   
    }
}


void InternalKeyboardUp ( unsigned char key, int x, int y )
{
    if ( internalWorld.State == BcGAME_MENU )
        return;

    switch ( key ) 
    {

	case 'x':
	case 'X':
            internalWorld.Ship->UpdateShield ( 0 );
            break;

	case '.':
	case '>':
	    internalWorld.Ship->ringsRotZspeed = 0.0;
	    internalWorld.Ship->triggerRight = 0;
	    break;
	    
	case ',':
	case '<':
	    internalWorld.Ship->ringsRotZspeed = 0.0;
	    internalWorld.Ship->triggerRight = 0;
	    break;
	    
	case ' ':
            internalWorld.Ship->fire = 0;
	default:
	    break;
    }
}


void InternalSpecial ( int k, int x, int y )
{
    if ( internalWorld.State == BcGAME_MENU )
    {
        switch ( k )
        {
            case GLUT_KEY_UP:
                internalWorld.Menu->UpdateMenu ( BcMENU_UP );
                break;
	      
            case GLUT_KEY_DOWN:
                internalWorld.Menu->UpdateMenu ( BcMENU_DOWN );
                break;
	    
            default:
                break;
        }
    }
    else
    {
        switch ( k ) 
        {
            case GLUT_KEY_LEFT:
                internalWorld.Ship->objData.xSpeed = -40.0;
                internalWorld.Ship->keyLeft = 1;
                break;
	    
            case GLUT_KEY_RIGHT:
                internalWorld.Ship->objData.xSpeed = 40.0;
                internalWorld.Ship->keyRight = 1;
                break;
	    
            case GLUT_KEY_UP:
                internalWorld.Ship->objData.ySpeed = 40.0;
                internalWorld.Ship->keyUp = 1;
                break;
	      
            case GLUT_KEY_DOWN:
                internalWorld.Ship->objData.ySpeed = -40.0;
                internalWorld.Ship->keyDown = 1;
	        break;

            case GLUT_KEY_F1:
                if ( internalWorld.showData )
                    internalWorld.showData = 0;
                else
                    internalWorld.showData = 1;
                break;

            case GLUT_KEY_F2:
                if ( internalWorld.texturing )
                    internalWorld.texturing = 0;
                else
                    internalWorld.texturing = 1;
	    
                break;

            case GLUT_KEY_F3:
                if ( internalWorld.smoothShading )
                {
                    internalWorld.smoothShading = 0;
                    glShadeModel ( GL_FLAT );
                }
                else
                {
                    internalWorld.smoothShading = 1;
                    glShadeModel ( GL_SMOOTH );
                }
                break;
	    
            default:
                break;
        }
    }
}


void InternalSpecialUp (int k, int x, int y )
{
    if ( internalWorld.State == BcGAME_MENU )
        return;

    switch ( k ) 
    {

	case GLUT_KEY_LEFT:
	    internalWorld.Ship->objData.xSpeed = 0.0;
	    internalWorld.Ship->keyLeft = 0;
	    break;
	    
	case GLUT_KEY_RIGHT:
	    internalWorld.Ship->objData.xSpeed = 0.0;
	    internalWorld.Ship->keyRight = 0;
	    break;
	    
	case GLUT_KEY_UP:
	    internalWorld.Ship->objData.ySpeed = 0.0;
	    internalWorld.Ship->keyUp = 0;
	    break;
	      
	case GLUT_KEY_DOWN:
            internalWorld.Ship->objData.ySpeed = 0.0;
	    internalWorld.Ship->keyDown = 0;
	    break;
	    
	default:
	    break;
    }
}

void InternalVisible ( int vis )
{
    if ( vis == GLUT_VISIBLE )
	glutIdleFunc ( InternalIdle );
    else
	glutIdleFunc ( NULL );
}


void InternalJoystick ( unsigned int buttons, int x, int y, int z )
{
    static int retButtonPressed = 0;
 
    //printf ( "Buttons = %d\n", buttons );

    //if ( y > 900 )
    //	printf ( "x = %d   y = %d\n", x, y );

    // Button A
    if ( buttons & 0x1 ) 
    {
        internalWorld.Ship->fire = 1;
        internalWorld.Ship->fireButton = 1;
    } 
    else if ( internalWorld.Ship->fireButton )
    {
        internalWorld.Ship->fire = 0;
        internalWorld.Ship->fireButton = 0;
    }

    if ( buttons & 8 )
    {
        internalWorld.Ship->UpdateShield ( 1 );
        retButtonPressed = 1;
    }
    else if ( retButtonPressed )
    {
        internalWorld.Ship->UpdateShield ( 0 );		
        retButtonPressed = 0;
    }

    // Right Trigger
    if ( buttons & 128 ) 
    {
	internalWorld.Ship->ringsRotZspeed = -200.0;
	internalWorld.Ship->triggerRight = 1;		
    } 
    else if ( internalWorld.Ship->triggerRight )
    {
	internalWorld.Ship->ringsRotZspeed = 0.0;
	internalWorld.Ship->triggerRight = 0;
    }
    
    // Left Trigger
    if ( buttons & 64 ) 
    {
	internalWorld.Ship->ringsRotZspeed = 200.0;
	internalWorld.Ship->triggerLeft = 1;		
    } 
    else if ( internalWorld.Ship->triggerLeft )
    {
	internalWorld.Ship->ringsRotZspeed = 0.0;
	internalWorld.Ship->triggerLeft = 0;
    }
    
    
    if (x < -300) 
    {
	internalWorld.Ship->objData.xSpeed = -40.0;
	internalWorld.Ship->joyLeft = 1;
    }
    else
    {
	if ( internalWorld.Ship->joyLeft)
	{
	    internalWorld.Ship->objData.xSpeed = 0.0;
	    internalWorld.Ship->joyLeft = 0;
	}
    } 
    
    if (x > 300) 
    {
	internalWorld.Ship->objData.xSpeed = 40.0;
	internalWorld.Ship->joyRight = 1;
    }
    else
    {
	if ( internalWorld.Ship->joyRight)
	{
	    internalWorld.Ship->objData.xSpeed = 0.0;
	    internalWorld.Ship->joyRight = 0;
	}
    } 
    
    if (y < -900) 
    {
        internalWorld.Ship->objData.ySpeed = 40.0;
        internalWorld.Ship->joyDown = 1;
    }
    else
    {
        if ( internalWorld.Ship->joyDown)
        {
            internalWorld.Ship->objData.ySpeed = 0.0;
            internalWorld.Ship->joyDown = 0;
        }
    } 
      
    if (y > 900) 
    {
        internalWorld.Ship->objData.ySpeed = -40.0;
        internalWorld.Ship->joyUp = 1;
    }
    else
    {
        if ( internalWorld.Ship->joyUp)
        {
            internalWorld.Ship->objData.ySpeed = 0.0;
            internalWorld.Ship->joyUp = 0;
        }
    }
}





