///////////////////////////////////////////////////////////////////////////////
// MarchingCubes.h
//
///////////////////////////////////////////////////////////////////////////////
#ifndef MARCHING_CUBES_H
#define MARCHING_CUBES_H

/*
    Glasteroids, a asteroids type game.
    Copyright (C) 1999 Matt Cohen

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; version 2 of the License.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/


#include <math.h>
#include <iostream.h>
#include "Triangles.h"

#define MAX_EXTRA_TRIS 12
#define BIT1 1
#define BIT2 2
#define BIT3 4
#define BIT4 8
#define BIT5 16
#define BIT6 32
#define BIT7 64
#define BIT8 128


/* Structure to hold added triangles */
typedef struct _extra_tris_t
{
    int triangles[MAX_EXTRA_TRIS*3];  
    int num_added;

}extra_tris_t;

/* Global */
typedef struct _Cell_Triangle_t{
    unsigned char a;
    unsigned char b;
    unsigned char c;
    float nx;
    float ny;
    float nz;
} Cell_Triangle_t; 


typedef struct _XYZ
{
    float x, y, z;
} XYZ;


class MarchingCubes
{

  public:

    MarchingCubes ( void );
    ~MarchingCubes ( void );

    int FindNormalForMidpoint ( unsigned char *, int, int, int, int, int, int,
				int, int, int, float *, float *, float * );
    int BuildTrianglesForSpecialCube ( int, int, int, int, int, int, int,
				       Cell_Triangle_t *, int * );

    int triTable[256][16];
    unsigned char specialCases[256];    

  private:

    int ConstructMidpointNormalArray ( void );
    void DestroyMidpointNormalArray ( void );

    void FillMidpointLocationArray ( void );
    void FillMidpointNormalArray ( void );
    void FillCubeTriangleArrays ( void );
    void FindMidpointNormalSum ( int, int, float *, 
				 float *, float * );
    void MakeUnitNormal ( float *, float *, float * );
    void FindNormalVector ( float, float, float, float, float, float,
			    float, float, float, float *, float *, float * );
    void InitExtraTriangles ( void );
    void AddTriangles ( int );
    int CheckCubeForExtraTriangles ( int, int, int );

    extra_tris_t extra;
    float ***midNormals;
    XYZ *midpointLoc;
};


#endif // MARCHING_CUBES_H
