#include "Bobcat.h"

/*
    Glasteroids, a asteroids type game.
    Copyright (C) 1999 Matt Cohen

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; version 2 of the License.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/


void BCworld::LoadSplashScreen ( char *filename )
{
    FILE *infile;
    int i;
    unsigned char *temp,*t,*f;
    unsigned char r, g, b;
    int splashWidth = 512;
    int splashHeight = 512;
    
    splashTexture = new unsigned char[splashWidth*splashHeight*4];
    temp = new unsigned char[splashWidth*splashHeight*3];
    
    infile = fopen ( filename, "r" );
    fread ( temp , splashWidth*splashHeight*3, 1, infile ); 
    fclose ( infile );

    t = temp;
    f = splashTexture;
    
    for ( i = 0; i < splashWidth*splashHeight; i++ )
    {
        *f = *t;     r = *t;    t++;    f++;
        *f = *t;     g = *t;    t++;    f++;
        *f = *t;     b = *t;    t++;    f++;
    
        *f = 255;                       f++;
    }

    delete temp;

    glGenTextures ( 1, &splashScreen_texture );
    glBindTexture ( GL_TEXTURE_2D, splashScreen_texture );

    glPixelStorei ( GL_UNPACK_ALIGNMENT, 1 );

    glTexParameterf ( GL_TEXTURE_2D, GL_TEXTURE_MAG_FILTER, GL_NEAREST );
    glTexParameterf ( GL_TEXTURE_2D, GL_TEXTURE_MIN_FILTER, GL_NEAREST );
  
    glTexImage2D ( GL_TEXTURE_2D, 0, GL_RGBA, splashWidth, splashHeight, 0,
                   GL_RGBA, GL_UNSIGNED_BYTE, splashTexture );    
}


void BCworld::DrawSplashScreen ( double time )
{
    static double totalTime = 0.0;
    static double displayLength = 5.0;
    
    if ( totalTime > displayLength )
        return;
    else
        totalTime += time;
    
    if ( texturing )
    {
        glEnable ( GL_TEXTURE_2D );
        glBindTexture ( GL_TEXTURE_2D, splashScreen_texture );
    }
    
    glColor3f ( 1.0, 1.0, 1.0 );
    glBegin ( GL_QUADS );

    glTexCoord2f ( 0.0, 1.0 );   glVertex3f ( -50.0, -35.0, 20.0 );
    glTexCoord2f ( 1.0, 1.0 );   glVertex3f (  50.0, -35.0, 20.0 );
    glTexCoord2f ( 1.0, 0.25 );  glVertex3f (  50.0,  35.0, 20.0 );    
    glTexCoord2f ( 0.0, 0.25 );  glVertex3f ( -50.0,  35.0, 20.0 );

    glEnd ( );

    if ( texturing )
        glDisable ( GL_TEXTURE_2D );
}


