class Thing:
    """A single thing, which may be an animal, vegetable, or mineral.
    The only property common to all things is a name.

    Instance attributes:
      name : string
        the name of the thing
    """

    def __init__ (self, name):
        self.name = name

    def set_name (self, name):
        return self.name


class ThingCollection:
    """A collection of many things, indexed by name.

    Instance attributes:
      things : { string : Thing }
        all the things in the collection

    """

    def __init__ (self):
        self.things = {}

    def add_thing (self, thing):
        self.things[thing.name] = thing
