#!/usr/bin/env python

"""
$URL: svn+ssh://svn/repos/trunk/grouch/lib/test/utest_util.py $
$Id: utest_util.py 25068 2004-09-10 17:13:58Z dbinger $
"""

try:
    from ExtensionClass import ExtensionClass, Base
    _used = ExtensionClass # so that import checker does not complain.
except:
    class Base:
        pass

from sancho.utest import UTest
from grouch.util import issubclass, isinstance


class SuperEC (Base):
    pass

class ChildEC (SuperEC):
    pass

class Super:
    pass

class Child (Super):
    pass

class ECTest (UTest):

    def _pre (self):
        self.super_ec = SuperEC()
        self.child_ec = ChildEC()
        self.super = Super()
        self.child = Child()

    def _post (self):
        del self.super_ec, self.child_ec
        del self.super, self.child


    test_cases = ['subclass_ec', 'subclass_normal',
                  'instance_ec', 'instance_normal']

    def check_subclass_ec (self):
        "EC classes and subclasses"

        assert issubclass(SuperEC, SuperEC)
        assert issubclass(SuperEC, Base)

        assert issubclass(ChildEC, ChildEC)
        assert issubclass(ChildEC, SuperEC)
        assert issubclass(ChildEC, Base)

        assert not issubclass(SuperEC, ChildEC)
        assert not issubclass(Base, ChildEC)

    def check_subclass_normal (self):
        "normal classes and subclasses"

        assert issubclass(Super, Super)
        assert not issubclass(Super, Base)

        assert issubclass(Child, Child)
        assert issubclass(Child, Super)
        assert not issubclass(Child, Base)

        assert not issubclass(Super, Child)
        assert not issubclass(Base, Child)

        assert not issubclass(Super, SuperEC)
        assert not issubclass(Child, SuperEC)

        assert not issubclass(ChildEC, Super)
        assert not issubclass(ChildEC, Child)

    def check_instance_ec (self):
        "EC instances"

        assert isinstance(self.super_ec, SuperEC)
        assert isinstance(self.super_ec, Base)
        assert not isinstance(self.super_ec, Super)
        assert not isinstance(self.super_ec, ChildEC)

        assert isinstance(self.child_ec, ChildEC)
        assert isinstance(self.child_ec, SuperEC)
        assert isinstance(self.child_ec, Base)
        assert not isinstance(self.child_ec, Super)
        assert not isinstance(self.child_ec, Child)


    def check_instance_normal (self):
        "normal instances"

        assert isinstance(self.super, Super)
        assert not isinstance(self.super, Base)
        assert not isinstance(self.super, SuperEC)
        assert not isinstance(self.super, ChildEC)

        assert isinstance(self.child, Child)
        assert isinstance(self.child, Super)
        assert not isinstance(self.child, Base)
        assert not isinstance(self.child, SuperEC)
        assert not isinstance(self.child, ChildEC)


# class ECTest


if __name__ == "__main__":
    ECTest()
