#!/usr/bin/env python


from distutils.core import setup

setup(name = "Grouch",
      version = "0.4",
      description = "System for describing and enforcing "
                    "a Python object schema",
      long_description = """\
An object schema describes every class in a collection of objects -- in
particular, it specifies the type of every instance attribute of every
class.  Grouch includes a type language for specifying attribute types,
a tool to parse specially-formatted class docstrings and output a
complete object schema, and another tool for walking a persistent object
graph and ensuring that every scrap of data in it conforms to the object
schema extracted from your class docstrings.  The API for defining,
querying, and enforcing types is fairly complete and well-documented, so
you can use Grouch's type system in other ways as well.
""",
      author = "CNRI",
      author_email = "webmaster@mems-exchange.org",
      license = "see LICENSE.txt",
      url = "http://www.mems-exchange.org/software/grouch/",

      package_dir = {"grouch": "lib"},
      packages = ["grouch"],
      scripts = ["scripts/gen_schema", "scripts/check_data"],
     )
